% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_references.R
\name{search_references}
\alias{search_references}
\title{Query references}
\usage{
search_references(query, doi = NULL, verbose = TRUE, ...)
}
\arguments{
\item{query}{either a character string including a single keyword or a named list containing a custom query (see details section below).
Note that if an empty character string is passed, then all datasets available are returned.}

\item{doi}{\code{character} a Digital Object Identifier  (DOI) of the article. Note that \code{query} is ignored if \code{doi} is specified.}

\item{verbose}{a \code{logical}. Should extra information be reported on progress?}

\item{...}{further arguments to be passed to \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
An object of class \code{mgSearchReferences}, which is a list that includes a
wide range of details associated to the reference, including all datasets
and networks related to the publication that are included in Mangal database.
}
\description{
Search for a specific reference using a key word or a Digital Object Identifier (DOI).
If the \code{query} is a character string, then all character columns in the table
are searched and the entries for which at least one
partial match was found are returned.
Alternatively, a named list can be used to look for an exact match in a specific column (see Details section).
}
\details{
Names of the list should match one of the column names within the table.
For the \code{reference} table, those are:
\itemize{
\item id: unique identifier of the reference
\item first_author: first author
\item doi: use \code{doi} instead
\item jstor: JSTOR identifier
\item year: year of publication.
}

Note that for lists with more than one element, only the first element is used, the others are ignored. An example is provided below.
}
\examples{
\donttest{
 search_references(doi = "10.2307/3225248")
 search_references(list(jstor = 3683041))
 search_references(list(year = 2010))
}
}
\references{
\itemize{
\item \url{https://mangal.io/#/}
\item \url{https://mangal-interactions.github.io/mangal-api/#references}
}
}
