% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sections.R
\name{get_sections}
\alias{get_sections}
\title{Retrieve Macrostrat section data}
\usage{
get_sections(
  section_id = NULL,
  column_id = NULL,
  unit_id = NULL,
  strat_name = NULL,
  strat_name_id = NULL,
  interval_name = NULL,
  interval_id = NULL,
  age = NULL,
  age_top = NULL,
  age_bottom = NULL,
  lat = NULL,
  lng = NULL,
  lithology = NULL,
  lithology_id = NULL,
  lithology_group = NULL,
  lithology_type = NULL,
  lithology_class = NULL,
  lithology_att = NULL,
  lithology_att_id = NULL,
  lithology_att_type = NULL,
  environ = NULL,
  environ_id = NULL,
  environ_type = NULL,
  environ_class = NULL,
  pbdb_collection_no = NULL,
  econ = NULL,
  econ_id = NULL,
  econ_type = NULL,
  econ_class = NULL,
  project_id = NULL,
  adjacents = FALSE
)
}
\arguments{
\item{section_id}{\code{integer}. Filter sections by their unique
identification number(s).}

\item{column_id}{\code{integer}. Filter sections to those contained within
column(s) as specified by their unique identification number(s).}

\item{unit_id}{\code{integer}. Filter sections to those containing unit(s) as
specified by their unique identification number(s).}

\item{strat_name}{\code{character}. Filter sections to those containing a
unit that fuzzy matches a stratigraphic name (e.g., "Hell Creek").}

\item{strat_name_id}{\code{integer}. Filter sections to those containing a
unit that matches one or more stratigraphic name(s) as specified by their
unique identification number(s).}

\item{interval_name}{\code{character}. Filter sections to those that overlap
with a named chronostratigraphic time interval (e.g., "Permian").}

\item{interval_id}{\code{integer}. Filter sections to those that overlap with
a chronostratigraphic time interval as specified by their unique
identification number(s).}

\item{age}{\code{numeric}. Filter sections to those that overlap with the
specified numerical age, in millions of years before present.}

\item{age_top}{\code{numeric}. Filter sections to those that overlap with the
age range between the specified numerical age and \code{age_bottom}. Should be
in millions of years before present. \code{age_bottom} must also be specified,
and this must be younger than \code{age_bottom}.}

\item{age_bottom}{\code{numeric}. Filter sections to those that overlap with
the age range between the specified numerical age and \code{age_top}. Should be
in millions of years before present. \code{age_top} must also be specified, and
this must be older than \code{age_top}.}

\item{lat}{\code{numeric}. Return the sections at the specified decimal
degree latitude. Must also specify \code{lng}.}

\item{lng}{\code{numeric}. Return the sections at the specified decimal
degree longitude. Must also specify \code{lat}.}

\item{lithology}{\code{character}. Filter sections to those containing a
named lithology (e.g., "shale", "sandstone").}

\item{lithology_id}{\code{integer}. Filter sections to those containing one
or more lithology(ies) as specified by their unique identification
number(s).}

\item{lithology_group}{\code{character}. Filter sections to those containing
a named lithology group (e.g., "sandstones", "mudrocks", "unconsolidated").}

\item{lithology_type}{\code{character}. Filter sections to those containing a
named lithology type (e.g., "carbonate", "siliciclastic").}

\item{lithology_class}{\code{character}. Filter sections to those containing
a named lithology class (e.g., "sedimentary", "igneous", "metamorphic").}

\item{lithology_att}{\code{character}. Filter sections to those containing a
named lithology attribute (e.g., "fine", "olivine", "poorly washed").}

\item{lithology_att_id}{\code{integer}. Filter sections to those containing
one or more lithology attribute(s) as specified by their unique
identification number(s).}

\item{lithology_att_type}{\code{character}. Filter sections to those
containing a named category of lithology attribute (e.g., "grains",
"lithology", "bedform").}

\item{environ}{\code{character}. Filter sections to those containing a named
environment (e.g., "delta plain", "pond").}

\item{environ_id}{\code{integer}. Filter sections to those containing one or
more environment(s) as specified by their unique identification number(s).}

\item{environ_type}{\code{character}. Filter sections to those containing a
named environment type (e.g., "fluvial", "eolian", "glacial").}

\item{environ_class}{\code{character}. Filter sections to those containing a
named environment class (e.g., "marine", "non-marine").}

\item{pbdb_collection_no}{\code{integer}. Filter sections to those containing
one or more Paleobiology Database collection(s) as specified by their
unique identification number(s).}

\item{econ}{\code{character}. Filter sections to those containing a named
economic attribute (e.g., "brick", "ground water", "gold").}

\item{econ_id}{\code{integer}. Filter sections to those containing one or
more economic attribute(s) as specified by their unique identification
number(s).}

\item{econ_type}{\code{character}. Filter sections to those containing a
named economic attribute type (e.g., "construction", "aquifer", "mineral").}

\item{econ_class}{\code{character}. Filter sections to those containing a
named economic attribute class (e.g., "material", "water", "precious
commodity").}

\item{project_id}{\code{integer}. Filter sections to those contained within
one or more Macrostrat project(s) as specified by their unique
identification number(s).}

\item{adjacents}{\code{logical}. If \code{column_id} or \code{lat}/\code{lng} is specified,
should all sections that touch the specified column be returned? Defaults
to \code{FALSE}.}
}
\value{
A \code{dataframe} containing the following columns:
\itemize{
\item \code{col_id}: The unique identification number of the Macrostrat
column containing the section.
\item \code{col_area}: The area of the associated Macrostrat column in
km\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
\item \code{section_id}: The unique identification number of the Macrostrat
section.
\item \code{project_id}: The unique identification number of the Macrostrat
project.
\item \code{max_thick}: The maximum thickness of the section, in meters.
\item \code{min_thick}: The minimum thickness of the section, in meters.
\item \code{t_age}: The age of the top of the section, estimated using the
continuous time age model, in millions of years before present.
\item \code{b_age}: The age of the bottom of the section, estimated using
the continuous time age model, in millions of years before present.
\item \code{pbdb_collections}: The number of PBDB collections contained
within the section.
\item \code{lith}: a \code{dataframe} containing the lithologies present
within the section, with the following columns:
\itemize{
\item \code{name}: The named lithology (e.g., "sandstone").
\item \code{type}: The named lithology type (e.g., "siliciclastic").
\item \code{class}: The named lithology class (e.g., "sedimentary").
\item \code{prop}: The proportion of the lithology within the section,
calculated from the individual Macrostrat units within the section.
\item \code{lith_id}: The unique identification number of the lithology.
}}
\itemize{
\item \code{environ}: a \code{dataframe} containing the environments
present within the section, with the following columns:
\itemize{
\item \code{name}: The named environment (e.g., "delta plain").
\item \code{type}: The named environment type (e.g., "siliciclastic").
\item \code{class}: The named environment class (e.g., "marine").
\item \code{prop}: The proportion of the environment within the section,
calculated from the individual Macrostrat units within the section.
\item \code{environ_id}: The unique identification number of the
environment.
}}
\itemize{
\item \code{econ}: a \code{dataframe} containing the economic attributes
present within the section, with the following columns:
\itemize{
\item \code{name}: The named economic attribute (e.g., "gold").
\item \code{type}: The named economic attribute type (e.g., "mineral").
\item \code{class}: The named economic attribute class (e.g., "precious
commodity").
\item \code{prop}: The proportion of the economic attribute out of
all economic attributes contained within the section, calculated
from the individual Macrostrat units within the section.
\item \code{econ_id}: The unique identification number of the economic
attribute.
}
}
}
\description{
A function to retrieve Macrostrat units contained within
gap-bound packages (sections).
}
\details{
More information can be found for the inputs for this function
using the definition functions (beginning with \code{defs_}).
}
\section{Developer(s)}{

Christopher D. Dean
}

\section{Reviewer(s)}{

Bethany Allen
}

\examples{
\donttest{
# Get sections within a specified column
ex1 <- get_sections(column_id = 10)
# Get sections at a specific geographic coordinate
ex2 <- get_sections(lng = -110.9, lat = 48.4)
}
}
\seealso{
Macrostrat data entities:
\code{\link{def_columns}()},
\code{\link{get_age_model}()},
\code{\link{get_columns}()},
\code{\link{get_units}()}
}
\concept{macrostrat}
