% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{calcAlignmentPerCluster}
\alias{calcAlignmentPerCluster}
\title{Calculate alignment for each cluster}
\usage{
calcAlignmentPerCluster(object, rand.seed = 1, k = NULL, by.dataset = FALSE)
}
\arguments{
\item{object}{\code{liger} object. Should call quantileAlignSNF before calling.}

\item{rand.seed}{Random seed for reproducibility (default 1).}

\item{k}{Number of nearest neighbors in calculating alignment (see calcAlignment for default).
Can pass in single value or vector with same length as number of clusters.}

\item{by.dataset}{Return alignment calculated for each dataset in cluster (default FALSE).}
}
\value{
Vector of alignment statistics (with names of clusters).
}
\description{
Returns alignment for each cluster in analysiss (see documentation for calcAlignment).
}
\examples{
\dontrun{
# ligerex (liger object), factorization complete
ligerex <- quantile_norm(ligerex)
# get alignment for each cluster
alignment_per_cluster <- calcAlignmentPerCluster(ligerex)
}
}
