% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{simulate.NuggetKriging}
\alias{simulate.NuggetKriging}
\title{Simulation from a \code{NuggetKriging} model object.}
\usage{
\method{simulate}{NuggetKriging}(
  object,
  nsim = 1,
  seed = 123,
  x,
  with_nugget = TRUE,
  will_update = FALSE,
  ...
)
}
\arguments{
\item{object}{S3 NuggetKriging object.}

\item{nsim}{Number of simulations to perform.}

\item{seed}{Random seed used.}

\item{x}{Points in model input space where to simulate.}

\item{with_nugget}{Set to FALSE if wish to remove the nugget in the simulation.}

\item{will_update}{Set to TRUE if wish to use update_simulate(...) later.}

\item{...}{Ignored.}
}
\value{
a matrix with \code{nrow(x)} rows and \code{nsim}
    columns containing the simulated paths at the inputs points
    given in \code{x}.
}
\description{
This method draws paths of the stochastic process at new input
points conditional on the values at the input points used in the
fit.
}
\note{
The names of the formal arguments differ from those of the
    \code{simulate} methods for the S4 classes \code{"km"} and
    \code{"KM"}. The formal \code{x} corresponds to
    \code{newdata}. These names are chosen \pkg{Python} and
    \pkg{Octave} interfaces to \pkg{libKriging}.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
plot(f)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1  *rnorm(nrow(X))
points(X, y, col = "blue")

k <- NuggetKriging(y, X, kernel = "matern3_2")

x <- seq(from = 0, to = 1, length.out = 101)
s <- simulate(k, nsim = 3, x = x)

lines(x, s[ , 1], col = "blue")
lines(x, s[ , 2], col = "blue")
lines(x, s[ , 3], col = "blue")
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
