% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{logLikelihoodFun.NuggetKriging}
\alias{logLikelihoodFun.NuggetKriging}
\alias{logLikelihoodFun,NuggetKriging,NuggetKriging-method}
\title{Compute Log-Likelihood of NuggetKriging Model}
\usage{
\method{logLikelihoodFun}{NuggetKriging}(object, theta_alpha, grad = FALSE, ...)
}
\arguments{
\item{object}{An S3 NuggetKriging object.}

\item{theta_alpha}{A numeric vector of (positive) range parameters and variance over variance plus nugget at
which the log-likelihood will be evaluated.}

\item{grad}{Logical. Should the function return the gradient?}

\item{...}{Not used.}
}
\value{
The log-Likelihood computed for given
    \eqn{\boldsymbol{theta_alpha}}{\frac{\sigma^2}{\sigma^2+nugget}}.
}
\description{
Compute Log-Likelihood of NuggetKriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))

k <- NuggetKriging(y, X, kernel = "matern3_2")
print(k)

theta0 = k$theta()
ll_alpha <- function(alpha) logLikelihoodFun(k,cbind(theta0,alpha))$logLikelihood
a <- seq(from = 0.9, to = 1.0, length.out = 101)
plot(a, Vectorize(ll_alpha)(a), type = "l",xlim=c(0.9,1))
abline(v = k$sigma2()/(k$sigma2()+k$nugget()), col = "blue")

alpha0 = k$sigma2()/(k$sigma2()+k$nugget())
ll_theta <- function(theta) logLikelihoodFun(k,cbind(theta,alpha0))$logLikelihood
t <- seq(from = 0.001, to = 2, length.out = 101)
plot(t, Vectorize(ll_theta)(t), type = 'l')
abline(v = k$theta(), col = "blue")

ll <- function(theta_alpha) logLikelihoodFun(k,theta_alpha)$logLikelihood
a <- seq(from = 0.9, to = 1.0, length.out = 31)
t <- seq(from = 0.001, to = 2, length.out = 101)
contour(t,a,matrix(ncol=length(a),ll(expand.grid(t,a))),xlab="theta",ylab="sigma2/(sigma2+nugget)")
points(k$theta(),k$sigma2()/(k$sigma2()+k$nugget()),col='blue')
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
