% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{op-definition}
\alias{op-definition}
\alias{:=}
\alias{is_definition}
\alias{new_definition}
\title{Definition operator}
\usage{
":="()

is_definition(x)

new_definition(lhs, rhs, env = caller_env())
}
\arguments{
\item{x}{An object to test.}

\item{lhs, rhs}{Expressions for the LHS and RHS of the definition.}

\item{env}{The evaluation environment bundled with the definition.}
}
\description{
The definition operator is typically used in DSL packages like
\code{ggvis} and \code{data.table}. It is exported in rlang as a alias to
\code{~}. This makes it a quoting operator that can be shared between
packages for computing on the language. Since it effectively
creates formulas, it is immediately compatible with rlang's
formulas and interpolation features.
}
\examples{
# This is useful to provide an alternative way of specifying
# arguments in DSLs:
fn <- function(...) ..1
f <- fn(arg := foo(bar) + baz)

is_formula(f)
f_lhs(f)
f_rhs(f)

# A predicate is provided to distinguish formulas from the
# colon-equals operator:
is_definition(a := b)
is_definition(a ~ b)
}
