% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{env_get}
\alias{env_get}
\title{Get an object from an environment}
\usage{
env_get(env = caller_env(), nm, inherit = FALSE)
}
\arguments{
\item{env}{An environment or an object bundling an environment,
e.g. a formula, \link{quosure} or \link[=is_closure]{closure}.}

\item{nm}{The name of a binding.}

\item{inherit}{Whether to look for bindings in the parent
environments.}
}
\value{
An object if it exists. Otherwise, throws an error.
}
\description{
\code{env_get()} extracts an object from an enviroment \code{env}. By
default, it does not look in the parent environments.
}
\examples{
parent <- child_env(NULL, foo = "foo")
env <- child_env(parent, bar = "bar")

# This throws an error because `foo` is not directly defined in env:
# env_get(env, "foo")

# However `foo` can be fetched in the parent environment:
env_get(env, "foo", inherit = TRUE)
}
