% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr-node.R
\name{duplicate}
\alias{duplicate}
\title{Duplicate an R object}
\usage{
duplicate(x, shallow = FALSE)
}
\arguments{
\item{x}{Any R object. However, uncopyable types like symbols and
environments are returned as is (just like with \code{<-}).}

\item{shallow}{This is relevant for recursive data structures like
lists, calls and pairlists. A shallow copy only duplicates the
top-level data structure. The objects contained in the list are
still the same.}
}
\description{
In R semantics, objects are copied by value. This means that
modifying the copy leaves the original object intact. Since,
copying data in memory is an expensive operation, copies in R are
as lazy as possible. They only happen when the new object is
actually modified. However, some operations (like \code{\link[=mut_node_car]{mut_node_car()}}
or \code{\link[=mut_node_cdr]{mut_node_cdr()}}) do not support copy-on-write. In those cases,
it is necessary to duplicate the object manually in order to
preserve copy-by-value semantics.
}
\details{
Some objects are not duplicable, like symbols and environments.
\code{duplicate()} returns its input for these unique objects.
}
\seealso{
pairlist
}
