% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval-tidy.R
\name{eval_tidy_}
\alias{eval_tidy_}
\title{Tidy evaluation in a custom environment}
\usage{
eval_tidy_(expr, bottom, top = NULL, env = caller_env())
}
\arguments{
\item{expr}{An expression.}

\item{bottom}{This is the environment (or the bottom of a set of
environments) containing definitions for overscoped symbols. The
bottom environment typically contains pronouns (like \code{.data})
while its direct parents contain the overscoping bindings. The
last one of these parents is the \code{top}.}

\item{top}{The top environment of the overscope. During tidy
evaluation, this environment is chained and rechained to lexical
enclosures of self-evaluating formulas (or quosures). This is the
mechanism that ensures hygienic scoping: the bindings in the
overscope have precedence, but the bindings in the dynamic
environment where the tidy quotes were created in the first place
are in scope as well.}

\item{env}{The lexical environment in which to evaluate \code{expr}.}
}
\description{
We recommend using \code{\link[=eval_tidy]{eval_tidy()}} in your DSLs as much as possible
to ensure some consistency across packages (\code{.data} and \code{.env}
pronouns, etc). However, some DSLs might need a different
evaluation environment. In this case, you can call \code{eval_tidy_()}
with the bottom and the top of your custom overscope (see
\code{\link[=as_overscope]{as_overscope()}} for more information).
}
\details{
Note that \code{eval_tidy_()} always installs a \code{.env} pronoun in the
bottom environment of your dynamic scope. This pronoun provides a
shortcut to the original lexical enclosure (typically, the dynamic
environment of a captured argument, see \code{\link[=enquo]{enquo()}}). It also
cleans up the overscope after evaluation. See \code{\link[=overscope_eval_next]{overscope_eval_next()}}
for evaluating several quosures in the same overscope.
}
