% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjstat.R
\name{toJSONstat}
\alias{toJSONstat}
\title{Convert data frame(s) to JSON-stat format}
\usage{
toJSONstat(x, value = "value", ...)
}
\arguments{
\item{x}{a data frame or list of data frames}

\item{value}{name of value column}

\item{...}{arguments passed on to \code{\link[jsonlite]{toJSON}}}
}
\value{
For a data frame: A JSON-stat format response with class
  \code{dataset}. For a list of data frames: A JSON-stat format response with
  class \code{collection}.
}
\description{
This function takes a data frame or list of data frames and returns
a string representation in JSON-stat format. The input data frame(s)
must be in maximally long tidy format: with only one \code{value}
column and all other columns representing dimensions.
}
\examples{
library(reshape)
irises <- melt(cbind(iris, Specimen=rep(1:50, 3)),
               id.vars=c("Species", "Specimen"))
irisJSONstat <- toJSONstat(list(iris=irises))
cat(substr(irisJSONstat, 1, 76))

# Add indentation whitespace
toJSONstat(as.data.frame(Titanic), value = "Freq", pretty = TRUE)
}

