% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{cond_true}
\alias{cond_true}
\title{Number of individuals for which the condition is true.}
\format{
An object of class \code{numeric} of length 1.
}
\usage{
cond_true
}
\description{
\code{cond_true} is a frequency that describes the
number of individuals in the current population \code{\link{N}}
for which the condition is \code{TRUE} (i.e., actually true cases).
}
\details{
Key relationships:

\enumerate{

\item to probabilities:
The frequency of \code{cond_true} individuals depends on the population size \code{\link{N}} and
the condition's prevalence \code{\link{prev}} and is split further into two subsets of
\code{\link{hi}} by the sensitivity \code{\link{sens}} and
\code{\link{mi}} by the miss rate \code{\link{mirt}}.

Perspectives:

\enumerate{
  \item by condition:

  The frequency \code{\link{cond_true}} is determined by the population size \code{\link{N}} times the prevalence \code{\link{prev}}:

  \code{ \link{cond_true} = \link{N} x \link{prev}}

  \item by decision:

  a. The frequency \code{\link{hi}} is determined by \code{\link{cond_true}} times the sensitivity \code{\link{sens}}
  (aka. hit rate \code{\link{HR}}):

  \code{ \link{hi} = \link{cond_true} x \link{sens}}


  b. The frequency \code{\link{mi}} is determined by \code{\link{cond_true}} times the miss rate \code{\link{mirt} = (1 - \link{sens})}:

  \code{ \link{mi} = \link{cond_true} x \link{mirt}  =  \link{cond_true} x (1 - \link{sens})}

}

  \item to other frequencies:
  In a population of size \code{\link{N}} the following relationships hold:

  \itemize{

    \item \code{\link{N} = \link{cond_true} + \link{cond_false}} (by condition)

    \item \code{\link{N} = \link{dec_pos} + \link{dec_neg}} (by decision)

    \item \code{\link{N} = \link{dec_cor} + \link{dec_err}} (by correspondence of decision to condition)

    \item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }

}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
cond_true <- 1000 * .10   # => sets cond_true to 10\% of 1000 = 100 cases.
is_freq(cond_true)        # => TRUE
is_prob(cond_true)        # => FALSE, as cond_true is no probability (but prev and sens are)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: 
\code{\link{N}},
\code{\link{cond_false}},
\code{\link{cr}},
\code{\link{dec_cor}},
\code{\link{dec_err}},
\code{\link{dec_neg}},
\code{\link{dec_pos}},
\code{\link{fa}},
\code{\link{hi}},
\code{\link{mi}}
}
\concept{frequencies}
\keyword{datasets}
