% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prism.R
\name{plot_prism}
\alias{plot_prism}
\title{Plot prism diagram of frequencies and probabilities.}
\usage{
plot_prism(prev = num$prev, sens = num$sens, mirt = NA,
  spec = num$spec, fart = NA, N = num$N, by = "cddc",
  area = "no", scale = "p", round = TRUE, f_lbl = "num",
  f_lbl_sep = NA, f_lwd = 0, p_lbl = "mix", arr_c = NA,
  lbl_txt = txt, title_lbl = txt$scen_lbl, cex_lbl = 0.9,
  cex_p_lbl = NA, col_pal = pal, mar_notes = TRUE, ...)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{N}{The number of individuals in the population.
A suitable value of \code{\link{N}} is computed, if not provided.
Note: \code{\link{N}} is not represented in the plot,
but used for computing frequency information \code{\link{freq}}
from current probabilities \code{\link{prob}}.}

\item{by}{A character code specifying 1 or 2 perspectives
that split the population into 2 subsets.
Specifying 1 perspective plots a frequency tree (single tree)
with 3 options:
  \enumerate{
  \item \code{"cd"}: by condition only;
  \item \code{"dc"}: by decision only;
  \item \code{"ac"}: by accuracy only.
  }
Specifying 2 perspectives plots a frequency prism (network, double tree)
with 6 options:
  \enumerate{
  \item \code{"cddc"}: by condition (cd) and by decision (dc) (default);
  \item \code{"cdac"}: by condition (cd) and by accuracy (ac);
  \item \code{"dccd"}: by decision (dc) and by condition (cd);
  \item \code{"dcac"}: by decision (dc) and by accuracy (ac);
  \item \code{"accd"}: by accuracy (ac) and by condition (cd);
  \item \code{"acdc"}: by accuracy (ac) and by decision (dc).
  }}

\item{area}{A character code specifying the shapes of the frequency boxes,
with 3 options:
  \enumerate{
  \item \code{"no"}: rectangular frequency boxes, not scaled (default);
  \item \code{"hr"}: frequency boxes are horizontal rectangles (scaled relative to N).
  \item \code{"sq"}: frequency boxes are squares (scaled relative to N).
  }}

\item{scale}{Scale probabilities and corresponding area dimensions either by
exact probability or by (rounded or non-rounded) frequency, with 2 options:
  \enumerate{
  \item \code{"p"}: scale main area dimensions by exact probability (default);
  \item \code{"f"}: re-compute probabilities from (rounded or non-rounded) frequencies
  and scale main area dimensions by their frequency.
  }
 Note: \code{scale} setting matters for the display of probability values and for
 area plots with small population sizes \code{\link{N}} when \code{round = TRUE}.}

\item{round}{A Boolean option specifying whether computed frequencies
are rounded to integers. Default: \code{round = TRUE}.}

\item{f_lbl}{Type of label for showing frequency values in 4 main areas,
with 6 options:
  \enumerate{
  \item \code{"def"}: abbreviated names and frequency values;
  \item \code{"abb"}: abbreviated frequency names only (as specified in code);
  \item \code{"nam"}: names only (as specified in \code{lbl_txt = txt});
  \item \code{"num"}: numeric frequency values only (default);
  \item \code{"namnum"}: names (as specified in \code{lbl_txt = txt}) and numeric values;
  \item \code{"no"}: no frequency labels (same for \code{f_lbl = NA} or \code{NULL}).
  }}

\item{f_lbl_sep}{Label separator for main frequencies
(used for \code{f_lbl = "def" OR "namnum"}).
Use \code{f_lbl_sep = ":\n"} to add a line break between name and numeric value.
Default: \code{f_lbl_sep = NA} (set to \code{" = "} or \code{":\n"} based on \code{f_lbl}).}

\item{f_lwd}{Line width of areas.
Default: \code{f_lwd = 0}.}

\item{p_lbl}{Type of label for showing 3 key probability links and values,
with many options:
  \enumerate{
  \item \code{"abb"}: show links and abbreviated probability names;
  \item \code{"def"}: show links and abbreviated probability names and values;
  \item \code{"min"}: show links and minimum (prominent) probability names;
  \item \code{"mix"}: show links and prominent probability names and all values (default);
  \item \code{"nam"}: show links and probability names (as specified in code);
  \item \code{"num"}: show links and numeric probability values;
  \item \code{"namnum"}: show links with names and numeric probability values;
  \item \code{"no"}: show links with no labels (same for \code{p_lbl = NA} or \code{NULL}).
  }}

\item{arr_c}{Arrow code for symbols at ends of probability links
(as a numeric value \code{-3 <= arr_c <= +6}),
with the following options:
  \itemize{
  \item \code{-1} to \code{-3}: points at one/other/both end/s;
  \item \code{0}: no symbols;
  \item \code{+1} to \code{+3}: V-arrow at one/other/both end/s;
  \item \code{+4} to \code{+6}: T-arrow at one/other/both end/s.
}
Default: \code{arr_c = NA}, but adjusted by \code{area}.}

\item{lbl_txt}{Default label set for text elements.
Default: \code{lbl_txt = \link{txt}}.}

\item{title_lbl}{Text label for current plot title.
Default: \code{title_lbl = txt$scen_lbl}.}

\item{cex_lbl}{Scaling factor for text labels (frequencies and headers).
Default: \code{cex_lbl = .90}.}

\item{cex_p_lbl}{Scaling factor for text labels (probabilities).
Default: \code{cex_p_lbl = cex_lbl - .05}.}

\item{col_pal}{Color palette.
Default: \code{col_pal = \link{pal}}.}

\item{mar_notes}{Boolean option for showing margin notes.
Default: \code{mar_notes = TRUE}.}

\item{...}{Other (graphical) parameters.}
}
\value{
Nothing (NULL).
}
\description{
\code{plot_prism} plots a network diagram of
from a sufficient and valid set of 3 essential probabilities
(\code{\link{prev}}, and
\code{\link{sens}} or its complement \code{\link{mirt}}, and
\code{\link{spec}} or its complement \code{\link{fart}})
or existing frequency information \code{\link{freq}}
and a population size of \code{\link{N}} individuals.
}
\details{
\code{plot_prism} generalizes and replaces \code{\link{plot_fnet}}
by removing the dependency on the R package \code{diagram}
and providing many additional options.
}
\examples{
## Basics:
# (1) Using global prob and freq values:
plot_prism()  # default prism plot,
# same as:
# plot_prism(by = "cddc", area = "no", scale = "p",
#            f_lbl = "num", f_lwd = 0, cex_lbl = .90,
#            p_lbl = "mix", arr_c = -2, cex_p_lbl = NA)

# (2) Providing values:
plot_prism(N = 10, prev = 1/2, sens = 4/5, spec = 3/5)
plot_prism(N = 10, prev = 1/3, sens = 3/5, spec = 4/5, area = "hr")
plot_prism(N = 10, prev = 1/4, sens = 3/5, spec = 2/5, area = "sq", mar_notes = TRUE)

## Custom color and text settings:
plot_prism(col_pal = pal_bw, f_lwd = .5, lwd = .5, lty = 2, # custom fbox color, prob links,
           font = 3, cex_p_lbl = .75)                       # and text labels

my_txt <- init_txt(cond_lbl = "The Truth", cond_true_lbl = "so true", cond_false_lbl = "so false",
                   hi_lbl = "TP", mi_lbl = "FN", fa_lbl = "FP", cr_lbl = "TN")
my_col <- init_pal(N_col = rgb(0, 169, 224, max = 255),  # seeblau
                   hi_col = "gold", mi_col = "firebrick1", fa_col = "firebrick2", cr_col = "orange")
plot_prism(f_lbl = "nam", lbl_txt = my_txt,
           col_pal = my_col, f_lwd = .5)

## Local values and custom color/txt settings:
plot_prism(N = 7, prev = 1/2, sens = 3/5, spec = 4/5, round = FALSE,
           by = "cdac", lbl_txt = txt_org, f_lbl = "namnum", f_lbl_sep = ":\\n",
           f_lwd = 1, col_pal = pal_rgb)  # custom colors

plot_prism(N = 5, prev = 1/2, sens = .8, spec = .5, scale = "p",  # note scale!
           by = "cddc", area = "hr", col_pal = pal_bw, f_lwd = 1) # custom colors

plot_prism(N = 3, prev = .50, sens = .50, spec = .50, scale = "p",              # note scale!
           area = "sq", lbl_txt = txt_org, f_lbl = "namnum", f_lbl_sep = ":\\n", # custom text
           col_pal = pal_kn, f_lwd = .5)                                        # custom colors

## Plot versions:
# (A) tree/single tree (nchar(by) == 2):
#     3 versions:
plot_prism(by = "cd", f_lbl = "def", col_pal = pal_mod) # by condition (freq boxes: hi mi fa cr)
plot_prism(by = "dc", f_lbl = "def", col_pal = pal_mod) # by decision  (freq boxes: hi fa mi cr)
plot_prism(by = "ac", f_lbl = "def", col_pal = pal_mod) # by decision  (freq boxes: hi cr mi fa)

# (B) prism/double tree (nchar(by) == 4):
#     6 (3 x 2) versions (+ 3 redundant ones):
plot_prism(by = "cddc")  # v01 (default)
plot_prism(by = "cdac")  # v02
plot_prism(by = "cdcd")  # (+) Message

plot_prism(by = "dccd")  # v03
plot_prism(by = "dcac")  # v04
plot_prism(by = "dcdc")  # (+) Message

plot_prism(by = "accd")  # v05
plot_prism(by = "acdc")  # v06
plot_prism(by = "acac")  # (+) Message

## Other options:

# area:
plot_prism(area = "no")  # rectangular boxes (default): (same if area = NA/NULL)
plot_prism(area = "hr")  # horizontal rectangles (widths on each level sum to N)
plot_prism(area = "sq")  # squares (areas on each level sum to N)

# scale (matters for scaled areas and small N):
plot_prism(N = 5, prev = .3, sens = .8, spec = .6,
           area = "hr", scale = "p")  # widths scaled by prob
plot_prism(N = 5, prev = .3, sens = .8, spec = .6,
           area = "hr", scale = "f")  # widths scaled by (rounded or non-rounded) freq
plot_prism(N = 4, prev = .2, sens = .7, spec = .8,
           area = "sq", scale = "p")  # areas scaled by prob
plot_prism(N = 4, prev = .2, sens = .7, spec = .8,
           area = "sq", scale = "f")  # areas scaled by (rounded or non-rounded) freq

## Frequency boxes:
# f_lbl:
plot_prism(f_lbl = "abb")     # abbreviated freq names (variable names)
plot_prism(f_lbl = "nam")     # only freq names
plot_prism(f_lbl = "num")     # only numeric freq values (default)
plot_prism(f_lbl = "namnum")  # names and numeric freq values
plot_prism(f_lbl = "namnum", cex_lbl = .75)  # smaller freq labels
plot_prism(f_lbl = NA)        # no freq labels
plot_prism(f_lbl = "def")     # informative default: short name and numeric value (abb = num)

# f_lwd:
plot_prism(f_lwd =  0)  # no lines (default), set to tiny_lwd = .001, lty = 0 (same if NA/NULL)
plot_prism(f_lwd =  1)  # basic lines
plot_prism(f_lwd =  3)  # thicker lines
plot_prism(f_lwd = .5)  # thinner lines

## Probability links:
# p_lbl:
plot_prism(p_lbl = "mix")     # abbreviated names with numeric values (abb = num)
plot_prism(p_lbl = NA)        # no prob labels (NA/NULL/"none")
plot_prism(p_lbl = "nam")     # only prob names
plot_prism(p_lbl = "num")     # only numeric prob values
plot_prism(p_lbl = "namnum")  # names and numeric prob values
plot_prism(p_lbl = "namnum", cex_p_lbl = .70)  # smaller prob labels
plot_prism(by = "cddc", p_lbl = "min")  # minimal labels
plot_prism(by = "cdac", p_lbl = "min")
plot_prism(by = "cddc", p_lbl = "mix")  # mix abbreviated names and numeric values
plot_prism(by = "cdac", p_lbl = "mix")
plot_prism(by = "cddc", p_lbl = "abb")  # abbreviated names
plot_prism(by = "cdac", p_lbl = "abb")
plot_prism(p_lbl = "any") # short name and value (abb = num)

# arr_c:
plot_prism(arr_c =  0)  # acc_c = 0: no arrows
plot_prism(arr_c = -3)  # arr_c = -1 to -3: points at both ends
plot_prism(arr_c = -2)  # point at far end
plot_prism(arr_c = +2)  # crr_c = 1-3: V-shape arrows at far end
plot_prism(arr_c = +3)  # V-shape arrows at both ends
plot_prism(arr_c = +6)  # arr_c = 4-6: T-shape arrows

## Plain plot versions:
plot_prism(area = "no", f_lbl = "def", p_lbl = "num", col_pal = pal_mod, f_lwd = 1,
           title_lbl = "", mar_notes = FALSE)  # remove titles and margin notes
plot_prism(area = "no", f_lbl = "nam", p_lbl = "min", col_pal = pal_rgb)
plot_prism(area = "no", f_lbl = "abb", p_lbl = "abb", col_pal = pal_bw)
plot_prism(area = "no", f_lbl = "num", p_lbl = "num", col_pal = pal_kn)

plot_prism(area = "hr", f_lbl = "num", f_lwd = .5, p_lbl = NA, arr_c = 0,
           col_pal = pal_mod, lwd = .5)
plot_prism(area = "hr", f_lbl = "nam", f_lwd = .5, p_lbl = NA, col_pal = pal_bw)
plot_prism(area = "hr", f_lbl = "nam", f_lwd = .5, p_lbl = "num")

plot_prism(area = "sq", f_lbl = "nam", p_lbl = NA, col_pal = pal_rgb)
plot_prism(area = "sq", f_lbl = "num", p_lbl = NA, f_lwd = 1, col_pal = pal_bw, lwd = .5)
plot_prism(area = "sq", f_lbl = "def", f_lbl_sep = ":\\n", p_lbl = NA, f_lwd = 1, col_pal = pal_kn)

## Suggested combinations:
plot_prism(f_lbl = "nam", p_lbl = "mix", col_pal = pal_mod)
plot_prism(f_lbl = "namnum", p_lbl = "mix", cex_lbl = .80, cex_p_lbl = .75)

plot_prism(area = "hr", f_lbl = "nam", p_lbl = "num", col_pal = pal_mod)
plot_prism(area = "hr", f_lbl = "abb", p_lbl = "abb", f_lwd = 1, col_pal = pal_bw)
plot_prism(area = "hr", f_lbl = "num", p_lbl = "mix", f_lwd = 1, cex_p_lbl = .75)

plot_prism(area = "sq", f_lbl = "nam", p_lbl = "abb", lbl_txt = txt_TF)
plot_prism(area = "sq", f_lbl = "num", p_lbl = "num", f_lwd = 1, col_pal = pal_rgb)
plot_prism(area = "sq", f_lbl = "namnum", p_lbl = "mix", f_lwd = .5, col_pal = pal_kn)

}
\seealso{
\code{\link{plot_fnet}} for older (obsolete) version;
\code{\link{plot_area}} for plotting mosaic plot (scaling area dimensions);
\code{\link{plot_bar}} for plotting frequencies as vertical bars;
\code{\link{plot_tab}} for plotting table (without scaling area dimensions);
\code{\link{pal}} contains current color settings;
\code{\link{txt}} contains current text settings.

Other visualization functions: \code{\link{plot.riskyr}},
  \code{\link{plot_area}}, \code{\link{plot_bar}},
  \code{\link{plot_curve}}, \code{\link{plot_fnet}},
  \code{\link{plot_icons}}, \code{\link{plot_mosaic}},
  \code{\link{plot_plane}}, \code{\link{plot_tab}},
  \code{\link{plot_tree}}
}
\concept{visualization functions}
