% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_xxxx_prob.R
\name{comp_freq_prob}
\alias{comp_freq_prob}
\title{Compute frequencies from (3 essential) probabilities.}
\usage{
comp_freq_prob(prev = prob$prev, sens = prob$sens, mirt = NA,
  spec = prob$spec, fart = NA, tol = 0.01, N = freq$N,
  round = TRUE)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{tol}{A numeric tolerance value for \code{\link{is_complement}}.
Default: \code{tol = .01}.}

\item{N}{The number of individuals in the population.
If \code{\link{N}} is unknown (\code{NA}),
a suitable minimum value is computed by \code{\link{comp_min_N}}.}

\item{round}{A Boolean value that determines whether frequencies are
rounded to the nearest integer. Default: \code{round = TRUE}.}
}
\value{
A list \code{\link{freq}} containing 11 frequency values.
}
\description{
\code{comp_freq_prob} computes current frequency information
from a sufficient and valid set of 3 essential probabilities
(\code{\link{prev}}, and
\code{\link{sens}} or its complement \code{\link{mirt}}, and
\code{\link{spec}} or its complement \code{\link{fart}}).
It returns a list of 11 frequencies (\code{\link{freq}})
as its output.
}
\details{
\code{comp_freq_prob} is a wrapper function for the more basic
function \code{\link{comp_freq}}, which only accepts
3 essential probabilities (i.e., \code{\link{prev}}, \code{\link{sens}},
and \code{\link{spec}}) as inputs.

Defaults and constraints:

\itemize{

\item Initial values:

By default, the values of \code{\link{prev}}, \code{\link{sens}},
   and \code{\link{spec}} are initialized to the probability information
   currently contained in \code{\link{prob}}.

Similarly, the population size \code{\link{N}} uses the frequency
   information currently contained in \code{\link{freq}} as its default.
   If \code{\link{N}} is unknown (\code{NA}),
   a suitable minimum value is computed by \code{\link{comp_min_N}}.

\item Constraints:

When using \code{comp_freq_prob} with the arguments
   \code{\link{mirt}} and \code{\link{fart}}, their complements
   \code{\link{sens}} and \code{\link{spec}} must either be
   valid complements (as in \code{\link{is_complement}}) or
   set to \code{NA}.

In addition to \code{\link{prev}}, both \code{\link{sens}}
   and \code{\link{spec}} are necessary arguments.
   If only their complements \code{\link{mirt}} or \code{\link{fart}}
   are known, first use \code{\link{comp_complement}},
   \code{\link{comp_comp_pair}}, or \code{\link{comp_complete_prob_set}}
   to compute the 3 essential probabilities.

\item Rounding:

By default, \code{comp_freq_prob} and its basic function
   \code{\link{comp_freq}} round frequencies to nearest integers
   to avoid decimal values in \code{\link{freq}}
   (i.e., \code{round = TRUE} by default).

When frequencies are rounded, probabilities computed from
   \code{\link{freq}} may differ from exact probabilities.

Using the option \code{round = FALSE} turns off rounding.

}

Key relationships between frequencies and probabilities
(see documentation of \code{\link{comp_freq}} or \code{\link{comp_prob}} for details):

\itemize{

\item Three perspectives on a population:

by condition / by decision / by accuracy.

\item Defining probabilities in terms of frequencies:

Probabilities can be computed as ratios between frequencies, but beware of rounding issues.

}

Functions translating between representational formats:
\code{\link{comp_prob_prob}}, \code{\link{comp_prob_freq}},
\code{comp_freq_prob}, \code{\link{comp_freq_freq}}
(see documentation of \code{\link{comp_prob_prob}} for details).
}
\examples{
# Basics:
comp_freq_prob(prev = .1, sens = .9, spec = .8, N = 100)  # => ok: hi = 9, ... cr = 72.
# Same case with complements (using NAs to prevent defaults):
comp_freq_prob(prev = .1, sens = NA, mirt = .1, spec = NA, fart = .2, N = 100)  # => same result

comp_freq_prob()                   # => ok, using probability info currently contained in prob
length(comp_freq_prob())           # => a list containing 9 frequencies
all.equal(freq, comp_freq_prob())  # => TRUE, unless prob has been changed after computing freq
freq <- comp_freq_prob()           # => computes frequencies and stores them in freq

# Ways to work:
comp_freq_prob(prev = 1, sens = 1, spec = 1, N = 101)  # => ok + warning: N hits (TP)

# Same case with complements (using NAs to prevent defaults):
comp_freq_prob(prev = 1, sens = NA, mirt = 0, spec = NA, fart = 0, N = 101)

comp_freq_prob(prev = 1, sens = 1, spec = 0, N = 102)  # => ok + warning: N hits (TP)
comp_freq_prob(prev = 1, sens = 0, spec = 1, N = 103)  # => ok + warning: N misses (FN)
comp_freq_prob(prev = 1, sens = 0, spec = 0, N = 104)  # => ok + warning: N misses (FN)
comp_freq_prob(prev = 0, sens = 1, spec = 1, N = 105)  # => ok + warning: N correct rejections (TN)

comp_freq_prob(prev = 0, sens = 1, spec = 0, N = 106)  # => ok + warning: N false alarms (FP)

# Same case with complements (using NAs to prevent defaults):
comp_freq_prob(prev = 0, sens = NA, mirt = 0,
               spec = NA, fart = 1, N = 106)  # => ok + warning: N false alarms (FP)

# Watch out for:
comp_freq_prob(prev = 1, sens = 1, spec = 1, N = NA)  # => ok + warning: N = 1 computed
comp_freq_prob(prev = 1, sens = 1, spec = 1, N =  0)  # => ok, but all 0 + warning (NPV = NaN)
comp_freq_prob(prev = .5, sens = .5, spec = .5, N = 10, round = TRUE)  # => ok, but all rounded
comp_freq_prob(prev = .5, sens = .5, spec = .5, N = 10, round = FALSE) # => ok, but not rounded

# Ways to fail:
comp_freq_prob(prev = NA, sens = 1, spec = 1, 100)  # => NAs + no warning (prev NA)
comp_freq_prob(prev = 1, sens = NA, spec = 1, 100)  # => NAs + no warning (sens NA)
comp_freq_prob(prev = 1, sens = 1, spec = NA, 100)  # => NAs + no warning (spec NA)
comp_freq_prob(prev = 8, sens = 1, spec = 1,  100)  # => NAs + warning (prev beyond range)
comp_freq_prob(prev = 1, sens = 8, spec = 1,  100)  # => NAs + warning (sens & spec beyond range)

}
\seealso{
\code{\link{comp_freq_freq}} computes current frequency information from (4 essential) frequencies;
\code{\link{comp_prob_freq}} computes current probability information from (4 essential) frequencies;
\code{\link{comp_prob_prob}} computes current probability information from (3 essential) probabilities;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{comp_comp_pair}} computes pairs of complements;
\code{\link{comp_complete_prob_set}} completes valid sets of probabilities;
\code{\link{comp_min_N}} computes a suitable population size \code{\link{N}} (if missing).

Other functions computing frequencies: \code{\link{comp_freq_freq}},
  \code{\link{comp_freq}}, \code{\link{comp_min_N}},
  \code{\link{comp_popu}}, \code{\link{comp_prob_prob}}

Other format conversion functions: \code{\link{comp_freq_freq}},
  \code{\link{comp_prob_freq}},
  \code{\link{comp_prob_prob}}
}
\concept{format conversion functions}
\concept{functions computing frequencies}
