% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskyr_class.R
\name{riskyr}
\alias{riskyr}
\title{Create riskyr scenarios.}
\format{An object of class "riskyr"
with 21 entries on textual and numeric information on
a riskyr scenario.}
\usage{
riskyr(scen.lbl = "", scen.lng = txt$scen.lng, scen.txt = txt$scen.txt,
  popu.lbl = txt$popu.lbl, cond.lbl = txt$cond.lbl,
  cond.true.lbl = txt$cond.true.lbl, cond.false.lbl = txt$cond.false.lbl,
  dec.lbl = txt$dec.lbl, dec.pos.lbl = txt$dec.pos.lbl,
  dec.neg.lbl = txt$dec.neg.lbl, hi.lbl = txt$hi.lbl, mi.lbl = txt$mi.lbl,
  fa.lbl = txt$fa.lbl, cr.lbl = txt$cr.lbl, prev = num$prev,
  sens = num$sens, spec = num$spec, fart = NA, N = NA,
  scen.src = txt$scen.src, scen.apa = txt$scen.apa)
}
\arguments{
\item{scen.lbl}{The current scenario title (sometimes in Title Caps).}

\item{scen.lng}{Language of the current scenario (as character code).
Options: \code{"en"} for English, \code{"de"} for  German.}

\item{scen.txt}{A longer text description of the current scenario
(which may extend over several lines).}

\item{popu.lbl}{A brief description of the current target population \code{\link{popu}} or sample.}

\item{cond.lbl}{A name for the \emph{condition} or feature (e.g., some disease) currently considered.}

\item{cond.true.lbl}{A label for the \emph{presence} of the current condition
or \code{\link{cond.true}} cases (the condition's true state of TRUE).}

\item{cond.false.lbl}{A label for the \emph{absence} of the current condition
or \code{\link{cond.false}} cases (the condition's true state of FALSE).}

\item{dec.lbl}{A name for the \emph{decision} or judgment (e.g., some diagnostic test) currently made.}

\item{dec.pos.lbl}{A label for \emph{positive} decisions
or \code{\link{dec.pos}} cases (e.g., predicting the presence of the condition).}

\item{dec.neg.lbl}{A label for \emph{negative} decisions
or \code{\link{dec.neg}} cases (e.g., predicting the absence of the condition).}

\item{hi.lbl}{A label for \emph{hits} or \emph{true positives} \code{\link{hi}}
(i.e., correct decisions of the presence of the condition, when the condition is actually present).}

\item{mi.lbl}{A label for \emph{misses} or \emph{false negatives} \code{\link{mi}}
(i.e., incorrect decisions of the absence of the condition when the condition is actually present).}

\item{fa.lbl}{A label for \emph{false alarms} or \emph{false positives} \code{\link{fa}}
(i.e., incorrect decisions of the presence of the condition when the condition is actually absent).}

\item{cr.lbl}{A label for \emph{correct rejections} or \emph{true negatives} \code{\link{cr}}
(i.e., a correct decision of the absence of the condition, when the condition is actually absent).

Numeric elements:}

\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.

Source information:}

\item{N}{The number of individuals in the scenario's population.
A suitable value of \code{\link{N}} is computed, if not provided.}

\item{scen.src}{Source information for the current scenario.}

\item{scen.apa}{Source information for the current scenario
in the style of the American Psychological Association (APA style).}
}
\value{
A list \code{object} of class "riskyr"
containing information on a risky scenario.

Text elements (all elements of \code{\link{txt}}:
}
\description{
The instantiation function \code{riskyr} is used to create
scenarios of class "riskyr",
which can then be visualized by the \code{plot} method \code{\link{plot.riskyr}}
and summarized by the \code{summary} method \code{\link{summary.riskyr}}.
}
\details{
Beyond basic scenario information
only the population size \code{\link{N}} and the essential probabilities
\code{\link{prev}}, \code{\link{sens}}, \code{\link{spec}}, and \code{\link{fart}}
are used and returned.
}
\examples{
# Defining a scenario:
custom.scenario <- riskyr(scen.lbl = "Identify reoffenders",
  cond.lbl = "Being a reoffender", popu.lbl = "Prisoners",
  cond.true.lbl = "Has reoffended", cond.false.lbl = "Has not reoffended",
  dec.lbl = "Test result",
  dec.pos.lbl = "will reoffend", dec.neg.lbl = "will not reoffend",
  hi.lbl = "Reoffender found", mi.lbl = "Reoffender missed",
  fa.lbl = "False accusation", cr.lbl = "Correct release",
  prev = .45,  # prevalence of being a reoffender.
  sens = .98, spec = .46, fart = NA, N = 753,
  scen.src = "Ficticious example scenario")

# Using a scenario:
summary(custom.scenario)
plot(custom.scenario)

}
