% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eh_test_subtype.R
\name{eh_test_subtype}
\alias{eh_test_subtype}
\title{Test for etiologic heterogeneity of risk factors according to disease
subtypes in a case-control study}
\usage{
eh_test_subtype(label, M, factors, data, digits = 2)
}
\arguments{
\item{label}{the name of the subtype variable in the data. This should be a
numeric variable with values 0 through M, where 0 indicates control subjects.
Must be supplied in quotes, e.g. \code{label = "subtype"}.}

\item{M}{is the number of subtypes. For M>=2.}

\item{factors}{a list of the names of the binary or continuous risk factors.
For binary or categorical risk factors the lowest level will be used as the
reference level.
e.g. \code{factors = list("age", "sex", "race")}.}

\item{data}{the name of the dataframe that contains the relevant variables.}

\item{digits}{the number of digits to round the odds ratios and associated
confidence intervals, and the estimates and associated standard errors.
Defaults to 2.}
}
\value{
Returns a list.

\code{beta} is a matrix containing the raw estimates from the
polytomous logistic regression model fit with \code{\link[mlogit]{mlogit}}
with a row for each risk factor and a column for each disease subtype.

\code{beta_se} is a matrix containing the raw standard errors from the
polytomous logistic regression model fit with \code{\link[mlogit]{mlogit}}
with a row for each risk factor and a column for each disease subtype.

\code{eh_pval} is a vector of unformatted p-values for testing whether each
risk factor differs across the levels of the disease subtype.

\code{or_ci_p} is a dataframe with the odds ratio (95\% CI) for each risk
factor/subtype combination, as well as a column of formatted etiologic
heterogeneity p-values.

\code{beta_se_p} is a dataframe with the estimates (SE) for
each risk factor/subtype combination, as well as a column of formatted
etiologic heterogeneity p-values.

\code{var_covar} contains the variance-covariance matrix associated with
the model estimates contained in \code{beta}.
}
\description{
\code{eh_test_subtype} takes the name of the variable containing
the pre-specified subtype labels, the number of subtypes, a list of risk
factors, and the name of the dataframe and returns results
related to the
question of whether each risk factor differs across levels of the disease
subtypes. Input is a dataframe that contains the risk factors of interest and
a
variable containing numeric class labels that is 0 for control subjects.
Risk factors can be either binary or continuous. For categorical risk
factors, a reference level should be selected and then indicator variables
for each remaining level of the risk factor should be created.
Categorical risk factors entered as is will be treated as ordinal.
The multinomial
logistic regression model is fit using \code{\link[mlogit]{mlogit}}.
}
\examples{

eh_test_subtype(
  label = "subtype",
  M = 4,
  factors = list("x1", "x2", "x3"),
  data = subtype_data,
  digits = 2
)
}
\author{
Emily C Zabor \email{zabore@mskcc.org}
}
