% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipc_get_analyses.R
\name{ipc_get_analyses}
\alias{ipc_get_analyses}
\title{Get analyses resources from the IPC API}
\usage{
ipc_get_analyses(
  country = NULL,
  year = NULL,
  type = NULL,
  id = NULL,
  api_key = NULL,
  tidy_df = TRUE
)
}
\arguments{
\item{country}{ISO2 country code.}

\item{year}{Single numeric year to filter analysis, calculated from the
maximum year of current period dates. If \code{NULL}, the default, returns
data for all years.}

\item{type}{Single string value of 'A' or 'C', corresponding to food security
conditions, either acute or chronic. If \code{NULL}, the default, returns
data for all types.}

\item{id}{Analysis ID.}

\item{api_key}{IPC API key. If \code{NULL} (the default), looks for \code{IPC_API_KEY}
in the environment.}

\item{tidy_df}{If \code{TRUE}, returns a tidy data frame wrangled as described in
the Tidy section of the documentation. If \code{FALSE}, returns
the data frame as returned direct from the IPC-CH API.}
}
\value{
Data frame of analysis metadata. Refer to the
\href{https://docs.api.ipcinfo.org}{IPC-CH Public API documentation} for details
on the returned values, with variables described in full in the \href{https://observablehq.com/@ipc/ipc-api-extended-documentation}{extended documentation}.
}
\description{
Accesses the areas resources on the IPC API. Contains detailed analysis
information. If \code{country}, \code{year} and/or \code{type} parameters are passed,
accesses the \strong{analyses} simplified API endpoint and pulls in all analyses or
filtered to those parameters. To get the details for a specific analysis
available on the \strong{analyses/\{id\}/\{period\}} advanced API endpoint,
pass in \code{id}. You cannot pass in both sets of parameters.
}
\details{
Analyses data is metadata related to specific analyses conducted by the IPC,
including title of the analysis, link to its release page on the IPC website,
and creation/modification dates.
}
\section{Tidy}{

When \code{tidy_df} is \code{TRUE}, the following changes are made to the initial
output to ensure each row represents a single analysis:
\enumerate{
\item \code{created} and \code{modified} columns are converted from character columns
to date columns.
\item \code{id} column is renamed to be \code{analysis_id}.
}
}

\examples{
\dontshow{if (!is.na(Sys.getenv("IPC_API_KEY", unset = NA))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# get all analyses details from the simplified API
ipc_get_analyses()

# get analysis details for a specific analysis ID
ipc_get_analyses(id = 12856213)
\dontshow{\}) # examplesIf}
}
