% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannon_cond_mutual_info}
\alias{shannon_cond_mutual_info}
\title{Shannon Conditional Mutual Information}
\usage{
shannon_cond_mutual_info(p_xyz, p_xz, p_yz, p_z, b = 2)
}
\arguments{
\item{p_xyz}{Dist specifying the joint distribution.}

\item{p_xz}{Dist specifying the \code{x,z}-marginal distribution.}

\item{p_yz}{Dist specifying the \code{y,z}-marginal distribution.}

\item{p_z}{Dist specifying the \code{z}-marginal distribution.}

\item{b}{Numeric giving the base of the logarithm.}
}
\value{
Numeric giving the Shannon conditional mutual information.
}
\description{
Compute the base-\code{b} conditional mutual information given joint
\code{p_xyz} and marginal \code{p_xz}, \code{p_yz}, \code{p_z} distributions.
}
\examples{
xyz <- Dist(c(24, 24, 9, 6, 25, 15, 10, 5))
xz  <- Dist(c(15, 9, 5, 10))
yz  <- Dist(c(9, 15, 10, 15))
z   <- Dist(c(3, 5))
shannon_cond_mutual_info(xyz, xz, yz, z)           # 0.1259494
shannon_cond_mutual_info(xyz, xz, yz, z, b = 3)    # 0.0794652

}
