% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realms.R
\name{C14toF14C}
\alias{C14toF14C}
\title{Calculate F14C values from C14 ages}
\usage{
C14toF14C(y, er = NULL, decimals = 5, lambda = 8033)
}
\arguments{
\item{y}{Reported mean of the 14C age.}

\item{er}{Reported error of the 14C age. If left empty, will translate y to F14C.}

\item{decimals}{Amount of decimals required for the F14C value. Defaults to 5.}

\item{lambda}{The mean-life of radiocarbon (based on Libby half-life of 5568 years)}
}
\value{
F14C values from C14 ages.
}
\description{
Calculate F14C values from radiocarbon ages
}
\details{
Post-bomb dates are often reported as F14C or fraction modern carbon. Since software such as Bacon expects radiocarbon ages,
this function can be used to calculate F14C values from radiocarbon ages. The reverse function of \link{F14C.age}.
}
\examples{
  C14toF14C(-2000, 20)
}
