% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile_download.R
\name{tile_download}
\alias{tile_download}
\title{Download requested tiles}
\usage{
tile_download(df_req, outdir = ".", unzip = TRUE, print_iter = TRUE, ...)
}
\arguments{
\item{df_req}{a data frame obtained using the \code{\link[=ortho_request]{ortho_request()}} and
\code{\link[=DEM_request]{DEM_request()}} functions}

\item{outdir}{(optional) name of the output directory;
by default, files are saved in the working directory}

\item{unzip}{TRUE (default) or FALSE, when TRUE the downloaded archive will
be extracted and removed; only suitable for certain elevation data}

\item{print_iter}{print the current iteration of all
(logical, TRUE default)}

\item{...}{additional argument for \code{\link[utils:download.file]{utils::download.file()}}}
}
\value{
georeferenced tiles with properties (resolution, year, etc.)
as specified in the input data frame
}
\description{
Download requested tiles
}
\examples{
\dontrun{
library(sf)
options(timeout = 600)
polygon_path = system.file("datasets/search_area.gpkg", package = "rgugik")
polygon = read_sf(polygon_path)

req_df = ortho_request(polygon)
tile_download(req_df[1, ]) # download the first image only

req_df = DEM_request(polygon)
tile_download(req_df[1, ]) # download the first DEM only
}
}
