% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_sparse6.R
\name{as_sparse6}
\alias{as_sparse6}
\alias{as_sparse6.matrix}
\alias{as_sparse6.igraph}
\alias{as_sparse6.network}
\alias{as_sparse6.list}
\alias{as_sparse6.default}
\title{Encode network data as \code{sparse6} symbols}
\usage{
as_sparse6(object, ...)

\method{as_sparse6}{matrix}(object, n = max(object, 0), ...)

\method{as_sparse6}{igraph}(object, ...)

\method{as_sparse6}{network}(object, ...)

\method{as_sparse6}{list}(object, ...)

\method{as_sparse6}{default}(object, ...)
}
\arguments{
\item{object}{an edgelist, igraph, or network object or a list thereof. See
Methods section below.}

\item{...}{other arguments passed to/from other methods}

\item{n}{number of vertices in the graph}
}
\value{
A character vector of 'sparse6' symbols.
}
\description{
Generic function encoding network data as 'sparse6' symbol(s). See below for
available methods.
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: Expects \code{object} to be a two-column matrix of
\emph{integers} which is interpreted as an edgelist of an undirected graph. By
default the network size is inferred to be the maximal element of \code{object}.
This can be overridden by providing the network size via the \code{n} argument,
the results will not be identical though (see the Examples).

\item \code{igraph}: Igraph \code{object} needs to be an undirected graph.
Requires \pkg{igraph} package.

\item \code{network}: Network \code{object} needs to be a directed network.
Requires \pkg{network} package.

\item \code{list}: If \code{object} is a list the function is applied to each
element. Consequently, it can be a list with a mixture of supported objects
classes (edgelist matrices, igraph, or network objects).

\item \code{default}: The default method fails gracefully.
}}

\examples{
# From edgelist matrix -----------------------------------------------------
elm <- matrix(c(
  1, 2,
  2, 3,
  3, 4
), ncol=2, byrow=TRUE)
as_sparse6(elm) # 1--2, 2--3, 3--4
as_sparse6(elm + 6) # 1, 2, 3, 4, 5, 6, 7--8, 8--9, 9--10
as_sparse6(elm, n = 10) # 1--2, 2--3, 3--4, 5, 6, 7, 8, 9, 10

# From igraph objects ------------------------------------------------------
if(requireNamespace("igraph")) {
  g <- igraph::graph_from_edgelist(elm, directed=FALSE)
  as_sparse6(g)
}

# From network objects --------------------------------
if(requireNamespace("network")) {
  net <- network::network(elm, directed=FALSE)
  as_graph6(net)
}

}
\seealso{
The 'sparse6' format is designed for undirected graphs. Error is
thrown in case it is given a directed graph.
}
