% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discCNN.R
\name{discCNN}
\alias{discCNN}
\alias{discCNN.default}
\alias{discCNN.formula}
\title{Condensed Nearest Neighbors for Regression by Discretization}
\usage{
\method{discCNN}{default}(x, y, ...)

\method{discCNN}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a double vector with the output regressand of each sample.}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output regressand and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
The result of applying the regression filter is a reduced dataset containing the clean samples (without errors or noise), since it removes noisy samples (those with errors).
This function returns an object of class \code{rfdata}, which contains information related to the noise filtering process in the form of a list with the following elements:
\item{xclean}{a data frame with the input attributes of clean samples (without errors).}
\item{yclean}{a double vector with the output regressand of clean samples (without errors).}
\item{numclean}{an integer with the amount of clean samples.}
\item{idclean}{an integer vector with the indices of clean samples.}
\item{xnoise}{a data frame with the input attributes of noisy samples (with errors).}
\item{ynoise}{a double vector with the output regressand of noisy samples (with errors).}
\item{numnoise}{an integer with the amount of noisy samples.}
\item{idnoise}{an integer vector with the indices of noisy samples.}
\item{filter}{the full name of the noise filter used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}

Note that objects of the class \code{rfdata} support \link{print.rfdata}, \link{summary.rfdata} and \link{plot.rfdata} methods.
}
\description{
Application of the discCNN noise filtering method in a regression dataset.
}
\details{
\code{discCNN} discretizes the numerical output variable to make it compatible with \emph{Condensed Nearest Neighbors} (CNN), typically used in classification tasks. 
CNN performs a first classification and stores all the samples that are misclassified.
Then, those stored samples are taken as a training set. The process stops when all the unstored samples are correctly classified.
}
\examples{
# load the dataset
data(rock)

# usage of the default method
set.seed(9)
out.def <- discCNN(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# show results
summary(out.def, showid = TRUE)

# usage of the method for class formula
set.seed(9)
out.frm <- discCNN(formula = perm ~ ., data = rock)

# check the match of noisy indices
all(out.def$idnoise == out.frm$idnoise)

}
\references{
L. Devroye, L. Gyorfi and G. Lugosi,
\strong{Condensed and edited nearest neighbor rules.}
\emph{In: A Probabilistic Theory of Pattern Recognition}, 31:303-313, 1996.
\doi{https://doi.org/10.1007/978-1-4612-0711-5_19}.

A. Arnaiz-González, J. Díez-Pastor, J. Rodríguez, C. García-Osorio,
\strong{Instance selection for regression by discretization.}
\emph{Expert Systems with Applications}, 54:340-350, 2016.
\doi{https://doi.org/10.1016/j.eswa.2015.12.046}.
}
\seealso{
\code{\link{discENN}}, \code{\link{discTL}}, \code{\link{discNCL}}, \code{\link{print.rfdata}}, \code{\link{summary.rfdata}}
}
