% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_gho_data}
\alias{get_gho_data}
\title{Returns GHO Data}
\usage{
get_gho_data(code, filter = NULL)
}
\arguments{
\item{code}{A GHO code.}

\item{filter}{A named list of filtering parameters. Each parameter must be the
correct type.}
}
\value{
A \code{GHO} object
}
\description{
Given a code, returns the corresponding GHO data.
}
\details{
Filtering parameters are given as a named list of the
form \code{list(COUNTRY = "FRA", ...)}.

If you mispecify the filtering parameter, you will get a 400 Bad
Request Error
}
\examples{

\dontrun{
result <- get_gho_data(
  code = "MDG_0000000001"
)
print(result, width = Inf)


result <- get_gho_data(
  code = "MDG_0000000001",
  filter = list(
    REGION = "EUR",
    YEAR = 2015
  )
)
print(result, width = Inf)
}
}
