% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_datasets.R
\name{occ_download_datasets}
\alias{occ_download_datasets}
\title{List datasets for a download}
\usage{
occ_download_datasets(key, limit = 20, start = 0, curlopts = list())
}
\arguments{
\item{key}{A key generated from a request, like that from \code{\link[=occ_download]{occ_download()}}}

\item{limit}{(integer/numeric) Number of records to return. Default: 20,
Max: 1000}

\item{start}{(integer/numeric) Record number to start at. Default: 0}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{\link[curl]{curl_options}}
for curl options}
}
\value{
a list with two slots:
\itemize{
\item meta: a single row data.frame with columns: \code{offset}, \code{limit},
\code{endofrecords}, \code{count}
\item results: a tibble with the results, of three columns: \code{downloadKey},
\code{datasetKey}, \code{numberRecords}
}
}
\description{
List datasets for a download
}
\note{
see \link{downloads} for an overview of GBIF downloads methods
}
\examples{
\dontrun{
occ_download_datasets(key="0003983-140910143529206")
occ_download_datasets(key="0003983-140910143529206", limit = 3)
occ_download_datasets(key="0003983-140910143529206", limit = 3, start = 10)
}
}
\seealso{
Other downloads: 
\code{\link{download_predicate_dsl}},
\code{\link{occ_download_cancel}()},
\code{\link{occ_download_dataset_activity}()},
\code{\link{occ_download_get}()},
\code{\link{occ_download_import}()},
\code{\link{occ_download_list}()},
\code{\link{occ_download_meta}()},
\code{\link{occ_download_queue}()},
\code{\link{occ_download_wait}()},
\code{\link{occ_download}()}
}
\concept{downloads}
