% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_import.R
\name{occ_download_import}
\alias{occ_download_import}
\alias{as.download}
\alias{as.download.character}
\alias{as.download.download}
\title{Import a downloaded file from GBIF.}
\usage{
occ_download_import(x = NULL, key = NULL, path = ".", ...)

as.download(path = ".", key = NULL)

\method{as.download}{character}(path = ".", key = NULL)

\method{as.download}{download}(path = ".", key = NULL)
}
\arguments{
\item{x}{The output of a call to \code{occ_download_get}}

\item{key}{A key generated from a request, like that from
\code{occ_download}}

\item{path}{Path to unzip file to. Default: \code{"."} Writes to
folder matching zip file name}

\item{...}{parameters passed on to \code{\link[data.table:fread]{data.table::fread()}}}
}
\value{
a tibble (data.frame)
}
\description{
Import a downloaded file from GBIF.
}
\details{
You can provide either x as input, or both key and path. We use
\code{\link[data.table:fread]{data.table::fread()}} internally to read data.
}
\examples{
\dontrun{
# First, kick off at least 1 download, then wait for the job to be complete
# Then use your download keys
res <- occ_download_get(key="0000066-140928181241064", overwrite=TRUE)
occ_download_import(res)

occ_download_get(key="0000066-140928181241064", overwrite = TRUE) \%>\%
  occ_download_import

# coerce a file path to the right class to feed to occ_download_import
as.download("0000066-140928181241064.zip")
as.download(key = "0000066-140928181241064")
occ_download_import(as.download("0000066-140928181241064.zip"))

# download a dump that has a CSV file
res <- occ_download_get(key = "0001369-160509122628363", overwrite=TRUE)
occ_download_import(res)
occ_download_import(key = "0001369-160509122628363")
}
}
