% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_dynamics.R
\name{popgrowth}
\alias{popgrowth}
\title{popgrowth}
\usage{
popgrowth(
  species_list = NULL,
  fields = NULL,
  server = getOption("FISHBASE_API", "fishbase"),
  version = get_latest_release(),
  db = default_db(server, version),
  ...
)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned.  Mostly for backwards compatibility as users can subset by column later}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}

\item{version}{a version string for the database, will default to the latest release. see [get_releases()] for details.}

\item{db}{the}

\item{...}{unused; for backwards compatibility only}
}
\value{
a table of population growth information by species; see details
}
\description{
This table contains information on growth, natural mortality and length
at first maturity, which serve as inputs to many fish stock assessment
models. The data can also be used to generate empirical relationships
between growth parameters or natural mortality estimates, and their
correlates (e.g., body shape, temperature, etc.), a line of research
that is useful both for stock assessment and for increasing understanding
of the evolution of life-history strategies
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
popgrowth("Oreochromis niloticus")
}
\dontshow{\}) # examplesIf}
}
\references{
http://www.fishbase.org/manual/english/fishbasethe_popgrowth_table.htm
}
