% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_names.R
\name{common_names}
\alias{common_names}
\alias{sci_to_common}
\title{common names}
\usage{
common_names(species_list, server = NULL, Language = NULL,
  fields = NULL)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}

\item{Language}{a string specifying the language for the common name, e.g. "English"}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned.  Mostly for backwards compatibility as users can subset by column later}
}
\value{
a data.frame of common names by species queried. If multiple species are queried,
The resulting data.frames are concatenated.
}
\description{
Return a table of common names
}
\details{
Note that there are many common names for a given sci name, so sci_to_common doesn't make sense
}
\examples{
\donttest{
common_names(c("Labroides bicolor",  "Bolbometopon muricatum"))

# subset by English language names
fish <- common_names("Bolbometopon muricatum")
}
}
