% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfPermute.R
\name{rfPermute}
\alias{rfPermute}
\alias{rfPermute.default}
\alias{rfPermute.formula}
\alias{as.randomForest}
\alias{print.rfPermute}
\alias{predict.rfPermute}
\title{Estimate Permutation p-values for Random Forest Importance Metrics}
\usage{
rfPermute(x, ...)

\method{rfPermute}{default}(x, y = NULL, ..., num.rep = 100, num.cores = 1)

\method{rfPermute}{formula}(
  formula,
  data = NULL,
  ...,
  subset,
  na.action = na.fail,
  num.rep = 100,
  num.cores = 1
)

as.randomForest(x)

\method{print}{rfPermute}(x, ...)

\method{predict}{rfPermute}(object, ...)
}
\arguments{
\item{x, y, formula, data, subset, na.action, \dots}{See \code{\link{randomForest}} 
for definitions. In \code{as.randomForest} this is either a 
\code{randomForest} or \code{rfPermute} object to be converted to a
\code{randomForest} object.}

\item{num.rep}{Number of permutation replicates to run to construct 
null distribution and calculate p-values (default = 100).}

\item{num.cores}{Number of CPUs to distribute permutation results over. 
Defaults to \code{NULL} which uses one fewer than the number of cores 
reported by \code{\link[parallel]{detectCores}}.}

\item{object}{an \code{rfPermute} model to be used for prediction. See
\code{\link[randomForest]{predict.randomForest}}}
}
\value{
An \code{rfPermute} object.
}
\description{
Estimate significance of importance metrics for a Random Forest 
  model by permuting the response variable. Produces null distribution of 
  importance metrics for each predictor variable and p-value of observed.
}
\details{
All other parameters are as defined in \code{randomForest.formula}. 
  A Random Forest model is first created as normal to calculate the observed 
  values of variable importance. The response variable is then permuted 
  \code{num.rep} times, with a new Random Forest model built for each 
  permutation step.
}
\examples{
# A regression model predicting ozone levels
data(airquality)
ozone.rp <- rfPermute(Ozone ~ ., data = airquality, na.action = na.omit, ntree = 100, num.rep = 50)
ozone.rp
  
# Plot the scaled importance distributions 
# Significant (p <= 0.05) predictors are in red
plotImportance(ozone.rp, scale = TRUE)

# Plot the importance null distributions and observed values for two of the predictors
plotNull(ozone.rp, preds = c("Solar.R", "Month"))


# A classification model classifying cars to manual or automatic transmission 
data(mtcars)

am.rp <- rfPermute(factor(am) ~ ., mtcars, ntree = 100, num.rep = 50)
summary(am.rp)


plotImportance(am.rp, scale = TRUE, sig.only = TRUE)



}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
