% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTrace.R
\name{plotTrace}
\alias{plotTrace}
\title{Plot Trace}
\usage{
plotTrace(x, pct.correct = TRUE, plot = TRUE)
}
\arguments{
\item{x}{a \code{rfPermute} or \code{randomForest} model object.}

\item{pct.correct}{display y-axis as percent correctly classified 
(\code{TRUE}) or OOB error rate (\code{FALSE}).}

\item{plot}{display the plot?}
}
\value{
the \code{ggplot2} object is invisibly returned.
}
\description{
Plot trace of cumulative OOB (classification) or MSE 
  (regression) error rate by number of trees.
}
\examples{
library(randomForest)
data(mtcars)

rf <- randomForest(factor(am) ~ ., mtcars)
plotTrace(rf)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
