% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ecitmatch.R, R/efetch.R, R/egquery.R, R/einfo.R, R/elink.R, R/epost.R, R/esearch.R, R/espell.R, R/esummary.R, R/eutil.R
\docType{methods}
\name{content,ecitmatch-method}
\alias{content}
\alias{content,ecitmatch-method}
\alias{content,efetch-method}
\alias{content,egquery-method}
\alias{content,einfo-method}
\alias{content,elink-method}
\alias{content,epost-method}
\alias{content,esearch-method}
\alias{content,espell-method}
\alias{content,esummary-method}
\alias{content,eutil-method}
\title{Extract the data content from an Entrez request}
\usage{
\S4method{content}{ecitmatch}(x, as = "text")

\S4method{content}{efetch}(x, as = NULL)

\S4method{content}{egquery}(x, as = NULL)

\S4method{content}{einfo}(x, as = NULL)

\S4method{content}{elink}(x, as = NULL)

\S4method{content}{epost}(x, as = NULL)

\S4method{content}{esearch}(x, as = NULL)

\S4method{content}{espell}(x, as = NULL)

\S4method{content}{esummary}(x, as = NULL)

content(x, ...)

\S4method{content}{eutil}(x, ...)
}
\arguments{
\item{x}{An \code{\linkS4class{eutil}} object.}

\item{as}{Type of output: \code{"text"}, \code{"xml"}, \code{"json"},
\code{"textConnection"}, or \code{"parsed"}. \code{content} attempts to
figure out the most appropriate output type, based on the \code{retmode} of
the object.}

\item{...}{Further arguments passed on to methods.}
}
\description{
There are five ways to access data returned by an Entrez request: as a character
string \code{(as = "text")}, as a \code{\link{textConnection}}
\code{(as = "textConnection")}, as an \code{\linkS4class{XMLInternalDocument}}
\code{(as = "xml")} or \code{json} object \code{(as = "json")}
(depending on the \code{retmode} with which the request was performed),
or parsed into a native R object, e.g. a \code{list} or a \code{data.frame}
\code{(as = "parsed")}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ecitmatch}: Return PubMed IDs if \code{as = "parsed"}.

\item \code{efetch}: 

\item \code{egquery}: 

\item \code{einfo}: 

\item \code{elink}: 

\item \code{epost}: 

\item \code{esearch}: 

\item \code{espell}: 

\item \code{esummary}: 

\item \code{eutil}: 
}}
\examples{
\dontrun{
## einfo() defaults to retmode 'xml'
e <- einfo()

## automatically return data as an 'XMLInternalDocument'.
if (e$no_errors()) {
  content(e)

  ## return the XML data as character string.
  cat(content(e, "text"))

  ## return DbNames parsed into a character vector.
  content(e, "parsed")
}

## return data as a JSON object
e2 <- einfo(db = "gene", retmode = "json")
if (e2$no_errors()) {
  content(e2)
}

## return a textConnection to allow linewise reading of the data.
x <- efetch("CP000828", "nuccore", rettype = "gbwithparts", retmode = "text")
con <- content(x, as = "textConnection")
readLines(con, 2)
close(con)
}
}
\seealso{
\code{\link{einfo}}, \code{\link{esearch}}, \code{\link{esummary}},
   \code{\link{efetch}}, \code{\link{elink}}, \code{\link{epost}},
   \code{\link{egquery}}, \code{\link{espell}}, \code{\link{ecitmatch}}.
}

