% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-python.R
\name{install_python}
\alias{install_python}
\title{Install Python}
\usage{
install_python(version, list = FALSE, force = FALSE)
}
\arguments{
\item{version}{The version of Python to install.}

\item{list}{Boolean; if set, list the set of available Python versions?}

\item{force}{Boolean; force re-installation even if the requested version
of Python is already installed?}
}
\description{
Download and install Python, using the \href{https://github.com/pyenv/pyenv}{pyenv}.
and \href{https://github.com/pyenv-win/pyenv-win}{pyenv-win} projects.
}
\details{
In general, it is recommended that Python virtual environments are created
using the copies of Python installed by \code{\link[=install_python]{install_python()}}. For example:\preformatted{library(reticulate)
version <- "3.8.7"
install_python(version = version)
virtualenv_create("my-environment", python_version = version)
use_virtualenv("my-environment", required = TRUE)
}
}
