/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.RelationFactory;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropLargeFC
extends PropLargeCSP<LargeRelation> {
    private final int[] currentTuple;
    private final IntIterableBitSet vrms;

    private PropLargeFC(IntVar[] vars, LargeRelation relation) {
        super(vars, relation);
        this.currentTuple = new int[vars.length];
        this.vrms = new IntIterableBitSet();
    }

    public PropLargeFC(IntVar[] vars, Tuples tuples) {
        this(vars, RelationFactory.makeLargeRelation(tuples, vars));
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.forcePropagate(PropagatorEventType.FULL_PROPAGATION);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CSPLarge({");
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(((IntVar[])this.vars)[i]).append(", ");
        }
        sb.append("})");
        return sb.toString();
    }

    private void filter() throws ContradictionException {
        boolean stop = false;
        int nbUnassigned = 0;
        int index = -1;
        for (int i = 0; !stop && i < ((IntVar[])this.vars).length; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) {
                ++nbUnassigned;
                index = i;
            } else {
                this.currentTuple[i] = ((IntVar[])this.vars)[i].getValue();
            }
            if (nbUnassigned <= 1) continue;
            stop = true;
        }
        if (!stop) {
            if (nbUnassigned == 1) {
                this.vrms.clear();
                this.vrms.setOffset(((IntVar[])this.vars)[index].getLB());
                int ub = ((IntVar[])this.vars)[index].getUB();
                int val = ((IntVar[])this.vars)[index].getLB();
                while (val <= ub) {
                    this.currentTuple[index] = val;
                    if (!this.relation.isConsistent(this.currentTuple)) {
                        this.vrms.add(val);
                    }
                    val = ((IntVar[])this.vars)[index].nextValue(val);
                }
                ((IntVar[])this.vars)[index].removeValues(this.vrms, this);
            } else if (!this.relation.isConsistent(this.currentTuple)) {
                this.fails();
            }
        }
    }
}

