% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_plots2pdf.R
\name{rp.plots2pdf}
\alias{rp.plots2pdf}
\title{Export multiple plots to PDF}
\usage{
rp.plots2pdf(
  rp.object,
  file = "rp_plots.pdf",
  groups = NULL,
  page.breaks = NULL,
  bw = FALSE
)
}
\arguments{
\item{rp.object}{A ResponsePatterns object.}

\item{file}{A string. A filename of the PDF file.}

\item{groups}{A list of vectors. Defines groups of items that should be plotted using the same color.}

\item{page.breaks}{A vector. Draws a vertical line after the items (useful if you want to display the pagination of the questionnaire in the plot).}

\item{bw}{A logical scalar. Should the plot be printed in black and white?}
}
\value{
Creates a PDF file.
}
\description{
This function exports individual plots of all observations to a PDF file. Limit the number of observation via \code{\link{rp.select}}.
}
\details{
If you have trouble exporting the PDF file, close all active graphical devices by running \code{\link[grDevices]{dev.off}} several times.
}
\examples{
rp <- rp.acors(rp.simdata, id.var="optional_ID")
\dontrun{rp.plots2pdf(rp)}
}
\seealso{
\code{\link{rp.acors}}, \code{\link{rp.patterns}}, \code{\link{rp.plot}}
}
