% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_patterns.R
\name{rp.patterns}
\alias{rp.patterns}
\title{Repetitive pattern analysis}
\usage{
rp.patterns(
  data,
  max.length = NULL,
  min.length = 2,
  id.var = NULL,
  na.rm = FALSE,
  std.patterns = TRUE,
  na.top = FALSE,
  store.data = TRUE
)
}
\arguments{
\item{data}{A data frame. A data set containing variables to analyze and, optionally, an ID variable.}

\item{max.length}{An integer. Define the maximum length of a pattern (cannot be longer than the number of variables/2).}

\item{min.length}{An integer. Define the minimum length of a pattern (defaults to 2).}

\item{id.var}{A string. If the data set contains an ID variable, specify it's name.}

\item{na.rm}{A logical scalar. Should missing values be ignored when comparing sequences of data?}

\item{std.patterns}{A logical scalar. If set to true, patterns are "standardized" by subtracting the minimum value from all elements in the sequence. As a result, patterns are compared in terms of their relative relationships (i.e., "1-2-3" and "3-4-5" are considered identical patterns). If set to FALSE, patterns are compared in terms of their absolute values (i.e., "1-2-3" and "3-4-5" are considered distinct patterns).}

\item{na.top}{A logical scalar. Should NA indices (i.e., those that could not be computed due to data missingness) be ranked at the top? Defaults to FALSE.}

\item{store.data}{A logical scalar. Should the data be stored within the object? Set to TRUE if you want to use the rp.plot or rp.save2csv functions.}
}
\value{
Returns an S4 object of class "ResponsePatterns".
}
\description{
This function searches mechanically for repetitive patterns in the data. It searches for patterns of a given length (all values between min.length and max.length) using an iterative algorithm. The patterns are defined based on the data: if a sequence of values occurs more than once within an observation, it is considered a repetition. The algorithm counts the number of repetitions for each pattern length and then weighs this sum by the length of the pattern (longer patterns are assigned higher weight). The total score for each respondent is determined as the sum of scores achieved for each pattern length and is standardized to a value between 0 and 1. It is essential to keep the variables in the order in which they were presented to respondents.
}
\details{
#' In order to prevent bias, only questions with the same answer scales should be analyzed at one time, ideally. Analyzing responses on two scales with different number ranges together (e.g., answers on scale 1–5 and answers on scale 1–100) can bias the results to a great extent. See \href{https://github.com/trihacek/responsePatterns}{GitHub} for an example of how to analyze data from several questionnaires simultaneously. Questions with unique scales or answer options where repetitive response patterns are unlikely or even impossible to emerge, like questions about gender or education, should be excluded prior to screening.
}
\examples{
rp.patterns(rp.simdata, id.var="optional_ID")
}
\seealso{
\code{\link{rp.acors}}, \code{\link{rp.indices}}, \code{\link{rp.select}}, \code{\link{rp.hist}}, \code{\link{rp.plot}}, \code{\link{rp.save2csv}}
}
