% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_alpha.R
\encoding{UTF-8}
\name{calc_alpha}
\alias{calc_alpha}
\title{Calculate the oxygen supply capacity (alpha)}
\usage{
calc_alpha(po2, mo2, avg_top_n = 1, MR = NULL, mo2_threshold = Inf)
}
\arguments{
\item{po2}{a vector of PO2 values.}

\item{mo2}{a vector of metabolic rate values. Must be the same length and corresponding to \code{po2}.}

\item{avg_top_n}{a numeric value representing the number of top \eqn{\alpha0} (MO2/PO2) values to average together to estimate \eqn{\alpha}. Default is 1. When analyzing a trial where the animal was not at MMR the whole time, we recommend no more than 3 to avoid diminishing the \eqn{\alpha} value with sub-maximal observations. If all observations are believed to be at maximal O2 supply capacity, \code{Inf} can be used to average all observations.}

\item{MR}{a vector of values for the metabolic rate at which \code{pcrit_alpha} should be returned. Default is \code{NULL}. If not specified, then \code{pcrit_alpha} is not returned and a message is added to the top of the return.}

\item{mo2_threshold}{a single numeric value above which \code{mo2} values are ignored. Useful to removing obviously erroneous values. Default is \code{Inf}.}
}
\value{
Returns a list of 1) alpha, 2) a list of the PO2, MO2, and alpha0 value(s) where alpha was reached (the number of observations averaged is set by \code{avg_top_n}), and 3) the Pcrit at a metabolic rate of \code{MR}.
}
\description{
The oxygen supply capacity (\eqn{\alpha}) is a species- and temperature-specific value quantifying an animal's ability to extract oxygen from the ambient medium to support its metabolism (e.g. umol O2 / g / hr / kPa). This function calculates \eqn{\alpha} based on the single highest \eqn{\alpha0} (MO2/PO2) value in the dataset. If there are outliers that make this prohibitive, consider setting a threshold MO2 value with \code{mo2_threshold}.
}
\examples{
mo2_data <- read.csv(system.file('extdata', 'mo2_v_po2.csv', package = 'respirometry'))
calc_alpha(po2 = mo2_data$po2, mo2 = mo2_data$mo2, MR = 1.5) # MR set to 1.5 to capture the 
# Pcrit corresponding to some of the lowest MO2 values recorded (something close to SMR).

# extract the alpha0 values that were averaged together
sapply(calc_alpha(po2 = mo2_data$po2, mo2 = mo2_data$mo2, 
  MR = 1.5, avg_top_n = 3)$alpha_obs, function(i) i[3])

}
\references{
Seibel, B. A., A. Andres, M. A. Birk, A. L. Burns, C. T. Shaw, A. W. Timpe, C. J. Welsh. 2021. “Oxygen supply capacity breathes new life into the critical oxygen partial pressure (Pcrit).” Journal of Experimental Biology.
}
\seealso{
\code{\link{calc_pcrit}}, \code{\link{plot_pcrit}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
