% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_MO2.R
\encoding{UTF-8}
\name{max_MO2}
\alias{max_MO2}
\title{Maximum MO2 supported by flow rate}
\usage{
max_MO2(flow_rate, min_pO2 = 90, pO2_in = 100, temp = 25, sal = 35,
  atm_pres = 1013.25)
}
\arguments{
\item{flow_rate}{water flow rate into respirometer (liters / min).}

\item{min_pO2}{minimum pO2 acceptable in respirometer (\% air saturation). Default is 90\% air saturation.}

\item{pO2_in}{pO2 of water entering respirometer (\% air saturation). Default is 100\% air saturation.}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}
}
\value{
The maximum whole-animal oxygen consumption rate (umol / hr) that can be sustained.
}
\description{
Calculates the maximum oxygen consumption rate (MO2) supported by a respirometer with a given flow rate. Useful for ensuring an acclimating animal maintains a normoxic environment.
}
\note{
Keep in mind that most organisms are very stressed upon being placed in a respirometer and their MO2 may be much higher than basal MO2.
}
\examples{
max_MO2(flow_rate = 1)

# What is the maximum MO2 organism I can place in my respirometer and still maintain at
# least 75\% air saturation when the intake fresh water is 1.5 LPM, 10 °C and 90\% air saturated?
max_MO2(flow_rate = 1.5, min_pO2 = 75, pO2_in = 90, temp = 10, sal = 0)

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
\references{
Steffensen JF. 1989. Some errors in respirometry of aquatic breathers: How to avoid and correct for them. Fish Physiol Biochem. 6:49–59. Equation 8.
}
\seealso{
\code{\link{min_flow}}, \code{\link{flush_water}}
}

