% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_rate.R
\name{calc_rate}
\alias{calc_rate}
\title{Calculate rate of change in oxygen over time}
\usage{
calc_rate(x, from = NULL, to = NULL, by = "time", plot = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{inspect} or \code{data.frame}. This is the timeseries of
paired values of oxygen against time from which to calculate rates.}

\item{from}{numeric value or vector. Defaults to \code{NULL}. The start of the
region(s) over which you want to calculate the rate in the units specified
in \code{by}. If a vector, each value must have a paired value in \code{to}.}

\item{to}{numeric value or vector. Defaults to \code{NULL}. The end of the
region(s) over which you want to calculate the rate in the units specified
in \code{by}. If a vector, each value must have a paired value in \code{from}.}

\item{by}{string. \code{"time"}, \code{"row"}, \code{"oxygen"} or \code{"proportion"} Defaults to
\code{"time"}.This is the method used to subset the data region between \code{from}
and \code{to}.}

\item{plot}{logical. Defaults to \code{TRUE}. Plot the results.}

\item{...}{Allows additional plotting controls to be passed, such as \code{pos},
\code{panel}, and \code{quiet = TRUE}.}
}
\value{
Output is a \code{list} object of class \code{calc_rate} containing input
parameters and data, various summary data, metadata, linear models, and the
primary output of interest \verb{$rate}, which can be background adjusted in
\code{\link{adjust_rate}} or converted to units in \code{\link{convert_rate}}.
}
\description{
Calculates rate of oxygen uptake or production from respirometry data. A rate
can be determined over the whole dataset, or on subsets of the data using the
\code{from} and \code{to} inputs to specify data regions in terms of \code{oxygen} or \code{time}
units, \code{row} numbers of the input data, or over a \code{proportion} of the total
oxygen used or produced (note, this last option works poorly with noisy or
fluctuating data). Multiple rates can be extracted from the same dataset by
using these inputs to enter vectors of paired values in the appropriate
metric. See Examples.
}
\details{
The function calculates rates by fitting a linear model of oxygen against
time, with the slope of this regression being the rate. There are no units
involved in \code{calc_rate}. This is a deliberate decision. The units of oxygen
concentration and time will be specified later in \code{\link[=convert_rate]{convert_rate()}} when
rates are converted to specific output units.

For continuous data recordings, it is recommended a \code{data.frame} containing
the data be prepared via \code{\link[=inspect]{inspect()}}, and entered as the \code{x} input. For
data not prepared like this, \code{x} can be a 2-column \code{data.frame} containing
numeric values of time (col 1) and oxygen (col 2). If multiple columns are
found in either an \code{inspect} or data frame input, only the first two columns
are used.
\subsection{Specifying regions}{

For calculating rates over specific regions of the data, the \code{from} and \code{to}
inputs in the \code{by} units of \code{"time"} (the default), "\code{oxygen}", \code{"row"}, or
\code{"proportion"} can be used. The \code{from} and \code{to} inputs do not need to be
precise; the function will use the closest values found.

Multiple regions can be examined within the same dataset by entering \code{from}
and \code{to} as vectors of paired values to specify different regions. In this
case, \verb{$rate} in the output will be a vector of multiple rates with each
result corresponding to the position of the paired \code{from} and \code{to} inputs. If
\code{from} and \code{to} are \code{NULL} (the default), the rate is determined over the
entire dataset.
}

\subsection{Plot}{

A plot is produced (provided \code{plot = TRUE}) showing the original data
timeseries of oxygen against time (bottom blue axis) and row index (top red
axis), with the region specified via the \code{from} and \code{to} inputs highlighted.
Second panel is a close-up of the rate region with linear model coefficients.
Third and fourth panels are summary plots of fit and residuals.
}

\subsection{Additional plotting options}{

If multiple rates have been calculated, by default the first (\code{pos = 1}) is
plotted. Others can be plotted by changing the \code{pos} input either in the main
function call, or by plotting the output, e.g. \code{plot(object, pos = 2)}. In
addition, each sub-panel can be examined individually by using the \code{panel}
input, e.g. \code{plot(object, panel = 2)}.

Console output messages can be suppressed using \code{quiet = TRUE}. If axis
labels (particularly y-axis) are difficult to read, \code{las = 2} can be passed
to make axis labels horizontal, and \code{oma} (outer margins, default \code{oma = c(0.4, 1, 1.5, 0.4)}), and \code{mai} (inner margins, default \code{mai = c(0.3, 0.15, 0.35, 0.15)}) used to adjust plot margins.
}

\subsection{S3 Generic Functions}{

Saved output objects can be used in the generic S3 functions \code{print()},
\code{summary()}, and \code{mean()}.
\itemize{
\item \code{print()}: prints a single result, by default the first rate. Others can be
printed by passing the \code{pos} input. e.g. \code{print(x, pos = 2)}
\item \code{summary()}: prints summary table of all results and metadata, or those
specified by the \code{pos} input. e.g. \code{summary(x, pos = 1:5)}. The summary can
be exported as a separate dataframe by passing \code{export = TRUE}.
\item \code{mean()}: calculates the mean of all rates, or those specified by the \code{pos}
input. e.g. \code{mean(x, pos = 1:5)} The mean can be exported as a separate value
by passing \code{export = TRUE}.
}
}

\subsection{More}{

For additional help, documentation, vignettes, and more visit the \code{respR}
website at \url{https://januarharianto.github.io/respR/}
}
}
\examples{
# Subset by 'time' (the default)
inspect(sardine.rd, time = 1, oxygen = 2, plot = FALSE) \%>\%
  calc_rate(from = 200, to = 1800)

# Subset by oxygen
inspect(sardine.rd, time = 1, oxygen = 2, plot = FALSE) \%>\%
  calc_rate(94, 91, by = "oxygen")

# Subset by row
inspect(sardine.rd, time = 1, oxygen = 2, plot = FALSE) \%>\%
  calc_rate(1000, 2000, by = "row")

# Use a data frame input, and calculate rate from multiple regions by
# using a vector in the 'from' and 'to' inputs
x <- calc_rate(intermittent.rd,
               from = c(200,2300,4100),
               to = c(1800,3200,4600),
               by = 'time',
               plot = FALSE)
# Print and summary of results
print(x)
summary(x)
# Plot the third of these results
plot(x, pos = 3)
# Plot only the timeseries plot and hide the legend
plot(x, pos = 3, panel = 1, legend = FALSE)
}
