% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_plots.R
\name{plot_ar}
\alias{plot_ar}
\title{Plot auto_rate summary tables}
\usage{
plot_ar(x, highlight = 1, pos = NULL, legend = TRUE, ...)
}
\arguments{
\item{x}{\code{auto_rate} or \code{auto_rate_subset} object}

\item{highlight}{integer. Which summary table rank regression to highlight.
Default is 1. If the input is an \code{auto_rate_subset} object this refers to
the rank from the original, unsubset results. Should be within \code{pos} range.}

\item{pos}{integer(s). Which summary table ranks to plot in lower plot.
Defaults to all.}

\item{legend}{logical. Suppress plot legends.}

\item{...}{Allows additional plotting controls to be passed.}
}
\value{
A plot of the auto_rate object results
}
\description{
Plots \code{auto_rate} summary table regressions in a way that visualises how they
are positioned within the data timeseries. If it is an \code{auto_rate_subset}
object, it will plot the subset regressions using the ranks of the original
results, so you can compare the subset and original.
}
