% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_class.R
\name{Distribution}
\alias{Distribution}
\title{Base class for Distributions}
\description{
Represents a modifiable Distribution family
}
\examples{
# Example for param_bounds:

# Create an Exponential Distribution with rate constrained to (0, 2)
# instead of (0, Inf)
my_exp <- dist_exponential()
my_exp$param_bounds$rate <- interval(c(0, 2))
my_exp$get_param_bounds()

fit_dist(my_exp, rexp(100, rate = 3), start = list(rate = 1))$params$rate


## ------------------------------------------------
## Method `Distribution$sample`
## ------------------------------------------------

dist_exponential(rate = 2.0)$sample(10)

## ------------------------------------------------
## Method `Distribution$density`
## ------------------------------------------------

dist_exponential()$density(c(1.0, 2.0), with_params = list(rate = 2.0))

## ------------------------------------------------
## Method `Distribution$probability`
## ------------------------------------------------

dist_exponential()$probability(
  c(1.0, 2.0),
  with_params = list(rate = 2.0)
)

## ------------------------------------------------
## Method `Distribution$quantile`
## ------------------------------------------------

dist_exponential()$quantile(c(0.1, 0.5), with_params = list(rate = 2.0))

## ------------------------------------------------
## Method `Distribution$hazard`
## ------------------------------------------------

dist_exponential(rate = 2.0)$hazard(c(1.0, 2.0))

## ------------------------------------------------
## Method `Distribution$diff_density`
## ------------------------------------------------

dist_exponential()$diff_density(
  c(1.0, 2.0),
  with_params = list(rate = 2.0)
)

## ------------------------------------------------
## Method `Distribution$diff_probability`
## ------------------------------------------------

dist_exponential()$diff_probability(
  c(1.0, 2.0),
  with_params = list(rate = 2.0)
)

## ------------------------------------------------
## Method `Distribution$is_in_support`
## ------------------------------------------------

dist_exponential(rate = 1.0)$is_in_support(c(-1.0, 0.0, 1.0))

## ------------------------------------------------
## Method `Distribution$is_discrete_at`
## ------------------------------------------------

dist_dirac(point = 0.0)$is_discrete_at(c(0.0, 1.0))

## ------------------------------------------------
## Method `Distribution$has_capability`
## ------------------------------------------------

dist_exponential()$has_capability("density")

## ------------------------------------------------
## Method `Distribution$get_type`
## ------------------------------------------------

dist_exponential()$get_type()
dist_dirac()$get_type()

dist_mixture(list(dist_dirac(), dist_exponential()))$get_type()
dist_mixture(list(dist_dirac(), dist_binomial()))$get_type()

## ------------------------------------------------
## Method `Distribution$get_components`
## ------------------------------------------------

dist_trunc(dist_exponential())$get_components()
dist_dirac()$get_components()
dist_mixture(list(dist_exponential(), dist_gamma()))$get_components()

## ------------------------------------------------
## Method `Distribution$is_discrete`
## ------------------------------------------------

dist_exponential()$is_discrete()
dist_dirac()$is_discrete()

## ------------------------------------------------
## Method `Distribution$is_continuous`
## ------------------------------------------------

dist_exponential()$is_continuous()
dist_dirac()$is_continuous()

## ------------------------------------------------
## Method `Distribution$require_capability`
## ------------------------------------------------

dist_exponential()$require_capability("diff_density")

## ------------------------------------------------
## Method `Distribution$get_dof`
## ------------------------------------------------

dist_exponential()$get_dof()
dist_exponential(rate = 1.0)$get_dof()

## ------------------------------------------------
## Method `Distribution$get_placeholders`
## ------------------------------------------------

dist_exponential()$get_placeholders()
dist_mixture(list(dist_dirac(), dist_exponential()))$get_placeholders()

## ------------------------------------------------
## Method `Distribution$get_params`
## ------------------------------------------------

dist_mixture(list(dist_dirac(), dist_exponential()))$get_params(
  with_params = list(probs = list(0.5, 0.5))
)

## ------------------------------------------------
## Method `Distribution$get_param_bounds`
## ------------------------------------------------

dist_mixture(
  list(dist_dirac(), dist_exponential()),
  probs = list(0.5, 0.5)
)$get_param_bounds()

dist_mixture(
  list(dist_dirac(), dist_exponential())
)$get_param_bounds()

dist_genpareto()$get_param_bounds()
dist_genpareto1()$get_param_bounds()

## ------------------------------------------------
## Method `Distribution$get_param_constraints`
## ------------------------------------------------

dist_mixture(
  list(dist_dirac(), dist_exponential())
)$get_param_constraints()

## ------------------------------------------------
## Method `Distribution$export_functions`
## ------------------------------------------------

tmp_env <- new.env(parent = globalenv())
dist_exponential()$export_functions(
  name = "exp",
  envir = tmp_env,
  with_params = list(rate = 2.0)
)
evalq(
  fitdistrplus::fitdist(rexp(100), "exp"),
  envir = tmp_env
)
}
\seealso{
Other Distributions: 
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{default_params}}{Get or set (non-recursive) default parameters of a
Distribution}

\item{\code{param_bounds}}{Get or set (non-recursive) parameter bounds
(box constraints) of a Distribution}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Distribution-new}{\code{Distribution$new()}}
\item \href{#method-Distribution-sample}{\code{Distribution$sample()}}
\item \href{#method-Distribution-density}{\code{Distribution$density()}}
\item \href{#method-Distribution-tf_logdensity}{\code{Distribution$tf_logdensity()}}
\item \href{#method-Distribution-probability}{\code{Distribution$probability()}}
\item \href{#method-Distribution-tf_logprobability}{\code{Distribution$tf_logprobability()}}
\item \href{#method-Distribution-quantile}{\code{Distribution$quantile()}}
\item \href{#method-Distribution-hazard}{\code{Distribution$hazard()}}
\item \href{#method-Distribution-diff_density}{\code{Distribution$diff_density()}}
\item \href{#method-Distribution-diff_probability}{\code{Distribution$diff_probability()}}
\item \href{#method-Distribution-is_in_support}{\code{Distribution$is_in_support()}}
\item \href{#method-Distribution-is_discrete_at}{\code{Distribution$is_discrete_at()}}
\item \href{#method-Distribution-tf_is_discrete_at}{\code{Distribution$tf_is_discrete_at()}}
\item \href{#method-Distribution-has_capability}{\code{Distribution$has_capability()}}
\item \href{#method-Distribution-get_type}{\code{Distribution$get_type()}}
\item \href{#method-Distribution-get_components}{\code{Distribution$get_components()}}
\item \href{#method-Distribution-is_discrete}{\code{Distribution$is_discrete()}}
\item \href{#method-Distribution-is_continuous}{\code{Distribution$is_continuous()}}
\item \href{#method-Distribution-require_capability}{\code{Distribution$require_capability()}}
\item \href{#method-Distribution-get_dof}{\code{Distribution$get_dof()}}
\item \href{#method-Distribution-get_placeholders}{\code{Distribution$get_placeholders()}}
\item \href{#method-Distribution-get_params}{\code{Distribution$get_params()}}
\item \href{#method-Distribution-tf_make_constants}{\code{Distribution$tf_make_constants()}}
\item \href{#method-Distribution-tf_compile_params}{\code{Distribution$tf_compile_params()}}
\item \href{#method-Distribution-get_param_bounds}{\code{Distribution$get_param_bounds()}}
\item \href{#method-Distribution-get_param_constraints}{\code{Distribution$get_param_constraints()}}
\item \href{#method-Distribution-export_functions}{\code{Distribution$export_functions()}}
\item \href{#method-Distribution-clone}{\code{Distribution$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-new"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$new(type, caps, params, name, default_params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Type of distribution. This is a string constant for the
default implementation. Distributions with non-constant type must
override the \code{get_type()} function.}

\item{\code{caps}}{Character vector of capabilities to fuel the default
implementations of \code{has_capability()} and \code{require_capability()}.
Distributions with dynamic capabilities must override the
\code{has_capability()} function.}

\item{\code{params}}{Initial parameter bounds structure, backing the
\code{param_bounds} active binding (usually a list of intervals).}

\item{\code{name}}{Name of the Distribution class. Should be \code{CamelCase} and end
with \code{"Distribution"}.}

\item{\code{default_params}}{Initial fixed parameters backing the
\code{default_params} active binding (usually a list of numeric / NULLs).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Construct a Distribution instance

Used internally by the \verb{dist_*} functions.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-sample"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-sample}{}}}
\subsection{Method \code{sample()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$sample(n, with_params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of samples to draw.}

\item{\code{with_params}}{Distribution parameters to use.
Each parameter value can also be a numeric vector of length \code{n}. In that
case the \code{i}-th sample will use the \code{i}-th parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sample from a Distribution
}

\subsection{Returns}{
A length \code{n} vector of i.i.d. random samples from the
Distribution with the specified parameters.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential(rate = 2.0)$sample(10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-density"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-density}{}}}
\subsection{Method \code{density()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$density(x, log = FALSE, with_params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector of points to evaluate the density at.}

\item{\code{log}}{Flag. If \code{TRUE}, return the log-density instead.}

\item{\code{with_params}}{Distribution parameters to use.
Each parameter value can also be a numeric vector of length \code{length(x)}.
In that case, the \code{i}-th density point will use the \code{i}-th parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Density of a Distribution
}

\subsection{Returns}{
A numeric vector of (log-)densities
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$density(c(1.0, 2.0), with_params = list(rate = 2.0))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-tf_logdensity"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-tf_logdensity}{}}}
\subsection{Method \code{tf_logdensity()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$tf_logdensity()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Compile a TensorFlow function for log-density evaluation
}

\subsection{Returns}{
A \code{tf_function} taking arguments \code{x} and \code{args} returning the
log-density of the Distribution evaluated at \code{x} with parameters \code{args}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-probability"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-probability}{}}}
\subsection{Method \code{probability()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$probability(
  q,
  lower.tail = TRUE,
  log.p = FALSE,
  with_params = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{Vector of points to evaluate the probability function at.}

\item{\code{lower.tail}}{If \code{TRUE}, return P(X <= q). Otherwise return P(X > q).}

\item{\code{log.p}}{If \code{TRUE}, probabilities are returned as \code{log(p)}.}

\item{\code{with_params}}{Distribution parameters to use.
Each parameter value can also be a numeric vector of length \code{length(q)}.
In that case, the \code{i}-th probability point will use the \code{i}-th
parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Cumulative probability of a Distribution
}

\subsection{Returns}{
A numeric vector of (log-)probabilities
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$probability(
  c(1.0, 2.0),
  with_params = list(rate = 2.0)
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-tf_logprobability"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-tf_logprobability}{}}}
\subsection{Method \code{tf_logprobability()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$tf_logprobability()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Compile a TensorFlow function for log-probability evaluation
}

\subsection{Returns}{
A \code{tf_function} taking arguments \code{qmin}, \code{qmax} and \code{args}
returning the log-probability of the Distribution evaluated over the
closed interval [\code{qmin}, \code{qmax}] with parameters \code{args}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-quantile}{}}}
\subsection{Method \code{quantile()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$quantile(
  p,
  lower.tail = TRUE,
  log.p = FALSE,
  with_params = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{Vector of probabilities.}

\item{\code{lower.tail}}{If \code{TRUE}, return P(X <= q). Otherwise return P(X > q).}

\item{\code{log.p}}{If \code{TRUE}, probabilities are returned as \code{log(p)}.}

\item{\code{with_params}}{Distribution parameters to use.
Each parameter value can also be a numeric vector of length \code{length(p)}.
In that case, the \code{i}-th quantile will use the \code{i}-th parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Quantile function of a Distribution
}

\subsection{Returns}{
A numeric vector of quantiles
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$quantile(c(0.1, 0.5), with_params = list(rate = 2.0))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-hazard"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-hazard}{}}}
\subsection{Method \code{hazard()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$hazard(x, log = FALSE, with_params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector of points.}

\item{\code{log}}{Flag. If \code{TRUE}, return the log-hazard instead.}

\item{\code{with_params}}{Distribution parameters to use.
Each parameter value can also be a numeric vector of length \code{length(x)}.
In that case, the \code{i}-th hazard point will use the \code{i}-th parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Hazard function of a Distribution
}

\subsection{Returns}{
A numeric vector of (log-)hazards
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential(rate = 2.0)$hazard(c(1.0, 2.0))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-diff_density"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-diff_density}{}}}
\subsection{Method \code{diff_density()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$diff_density(x, log = FALSE, with_params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector of points.}

\item{\code{log}}{Flag. If \code{TRUE}, return the gradient of the log-density
instead.}

\item{\code{with_params}}{Distribution parameters to use.
Each parameter value can also be a numeric vector of length \code{length(x)}.
In that case, the \code{i}-th density point will use the \code{i}-th parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Gradients of the density of a Distribution
}

\subsection{Returns}{
A list structure containing the (log-)density gradients of all
free parameters of the Distribution evaluated at \code{x}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$diff_density(
  c(1.0, 2.0),
  with_params = list(rate = 2.0)
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-diff_probability"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-diff_probability}{}}}
\subsection{Method \code{diff_probability()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$diff_probability(
  q,
  lower.tail = TRUE,
  log.p = FALSE,
  with_params = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{Vector of points to evaluate the probability function at.}

\item{\code{lower.tail}}{If \code{TRUE}, return P(X <= q). Otherwise return P(X > q).}

\item{\code{log.p}}{If \code{TRUE}, probabilities are returned as \code{log(p)}.}

\item{\code{with_params}}{Distribution parameters to use.
Each parameter value can also be a numeric vector of length \code{length(q)}.
In that case, the \code{i}-th probability point will use the \code{i}-th
parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Gradients of the cumulative probability of a Distribution
}

\subsection{Returns}{
A list structure containing the cumulative (log-)probability
gradients of all free parameters of the Distribution evaluated at \code{q}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$diff_probability(
  c(1.0, 2.0),
  with_params = list(rate = 2.0)
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-is_in_support"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-is_in_support}{}}}
\subsection{Method \code{is_in_support()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$is_in_support(x, with_params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector of points}

\item{\code{with_params}}{Distribution parameters to use.
Each parameter value can also be a numeric vector of length \code{length(x)}.
In that case, the \code{i}-th point will use the \code{i}-th parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Determine if a value is in the support of a Distribution
}

\subsection{Returns}{
A logical vector with the same length as \code{x} indicating whether
\code{x} is part of the support of the distribution given its parameters.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential(rate = 1.0)$is_in_support(c(-1.0, 0.0, 1.0))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-is_discrete_at"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-is_discrete_at}{}}}
\subsection{Method \code{is_discrete_at()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$is_discrete_at(x, with_params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector of points}

\item{\code{with_params}}{Distribution parameters to use.
Each parameter value can also be a numeric vector of length \code{length(x)}.
In that case, the \code{i}-th point will use the \code{i}-th parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Determine if a value has positive probability
}

\subsection{Returns}{
A logical vector with the same length as \code{x} indicating whether
there is a positive probability mass at \code{x} given the Distribution
parameters.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_dirac(point = 0.0)$is_discrete_at(c(0.0, 1.0))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-tf_is_discrete_at"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-tf_is_discrete_at}{}}}
\subsection{Method \code{tf_is_discrete_at()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$tf_is_discrete_at()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Compile a TensorFlow function for discrete support checking
}

\subsection{Returns}{
A \code{tf_function} taking arguments \code{x} and \code{args} returning whether
the Distribution has a point mass at \code{x} given parameters \code{args}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-has_capability"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-has_capability}{}}}
\subsection{Method \code{has_capability()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$has_capability(caps)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{caps}}{Character vector of capabilities}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Check if a capability is present
}

\subsection{Returns}{
A logical vector the same length as \code{caps}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$has_capability("density")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-get_type"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-get_type}{}}}
\subsection{Method \code{get_type()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$get_type()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the type of a Distribution. Type can be one of \code{discrete},
\code{continuous} or \code{mixed}.
}

\subsection{Returns}{
A string representing the type of the Distribution.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$get_type()
dist_dirac()$get_type()

dist_mixture(list(dist_dirac(), dist_exponential()))$get_type()
dist_mixture(list(dist_dirac(), dist_binomial()))$get_type()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-get_components"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-get_components}{}}}
\subsection{Method \code{get_components()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$get_components()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the component Distributions of a transformed Distribution.
}

\subsection{Returns}{
A possibly empty list of Distributions
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_trunc(dist_exponential())$get_components()
dist_dirac()$get_components()
dist_mixture(list(dist_exponential(), dist_gamma()))$get_components()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-is_discrete"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-is_discrete}{}}}
\subsection{Method \code{is_discrete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$is_discrete()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Check if a Distribution is discrete, i.e. it has a density with respect
to the counting measure.
}

\subsection{Returns}{
\code{TRUE} if the Distribution is discrete, \code{FALSE} otherwise.
Note that mixed distributions are not discrete but can have point masses.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$is_discrete()
dist_dirac()$is_discrete()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-is_continuous"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-is_continuous}{}}}
\subsection{Method \code{is_continuous()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$is_continuous()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Check if a Distribution is continuous, i.e. it has a density with respect
to the Lebesgue measure.
}

\subsection{Returns}{
\code{TRUE} if the Distribution is continuous, \code{FALSE} otherwise.
Note that mixed distributions are not continuous.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$is_continuous()
dist_dirac()$is_continuous()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-require_capability"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-require_capability}{}}}
\subsection{Method \code{require_capability()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$require_capability(
  caps,
  fun_name = paste0(sys.call(-1)[[1]], "()")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{caps}}{Character vector of Capabilities to require}

\item{\code{fun_name}}{Frienly text to use for generating the error message in
case of failure.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Ensure that a Distribution has all required capabilities.
Will throw an error if any capability is missing.
}

\subsection{Returns}{
Invisibly \code{TRUE}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$require_capability("diff_density")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-get_dof"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-get_dof}{}}}
\subsection{Method \code{get_dof()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$get_dof()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the number of degrees of freedom of a Distribution family.
Only parameters without a fixed default are considered free.
}

\subsection{Returns}{
An integer representing the degrees of freedom suitable e.g. for
AIC calculations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$get_dof()
dist_exponential(rate = 1.0)$get_dof()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-get_placeholders"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-get_placeholders}{}}}
\subsection{Method \code{get_placeholders()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$get_placeholders()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get Placeholders of a Distribution family.
Returns a list of free parameters of the family.
Their values will be \code{NULL}.

If the Distribution has Distributions as parameters, placeholders will be
computed recursively.
}

\subsection{Returns}{
A named list containing any combination of (named or unnamed)
lists and \code{NULL}s.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_exponential()$get_placeholders()
dist_mixture(list(dist_dirac(), dist_exponential()))$get_placeholders()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-get_params"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-get_params}{}}}
\subsection{Method \code{get_params()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$get_params(with_params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{with_params}}{Optional parameter overrides with the same structure
as \code{dist$get_params()}. Given Parameter values are expected to be length
1.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Get a full list of parameters, possibly including placeholders.
}

\subsection{Returns}{
A list representing the (recursive) parameter structure of the
Distribution with values for specified parameters and \code{NULL} for free
parameters that are missing both in the Distributions parameters and in
\code{with_params}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_mixture(list(dist_dirac(), dist_exponential()))$get_params(
  with_params = list(probs = list(0.5, 0.5))
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-tf_make_constants"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-tf_make_constants}{}}}
\subsection{Method \code{tf_make_constants()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$tf_make_constants(with_params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{with_params}}{Optional parameter overrides with the same structure
as \code{dist$tf_make_constants()}. Given Parameter values are expected to be
length 1.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Get a list of constant TensorFlow parameters
}

\subsection{Returns}{
A list representing the (recursive) constant parameters of the
Distribution with values sprecified by parameters. Each constant is a
TensorFlow Tensor of dtype \code{floatx}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-tf_compile_params"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-tf_compile_params}{}}}
\subsection{Method \code{tf_compile_params()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$tf_compile_params(input, name_prefix = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{A keras layer to bind all outputs to}

\item{\code{name_prefix}}{Prefix to use for layer names}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Compile distribution parameters into tensorflow outputs
}

\subsection{Returns}{
A list with two elements
\itemize{
\item \code{outputs} a flat list of keras output layers, one for each parameter.
\item \code{output_inflater} a function taking keras output layers and
transforming them into a list structure suitable for passing to the
loss function returned by \code{\link[=tf_compile_model]{tf_compile_model()}}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-get_param_bounds"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-get_param_bounds}{}}}
\subsection{Method \code{get_param_bounds()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$get_param_bounds()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get Interval bounds on all Distribution parameters
}

\subsection{Returns}{
A list representing the free (recursive) parameter structure of
the Distribution with \code{Interval} objects as values representing the
bounds of the respective free parameters.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_mixture(
  list(dist_dirac(), dist_exponential()),
  probs = list(0.5, 0.5)
)$get_param_bounds()

dist_mixture(
  list(dist_dirac(), dist_exponential())
)$get_param_bounds()

dist_genpareto()$get_param_bounds()
dist_genpareto1()$get_param_bounds()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-get_param_constraints"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-get_param_constraints}{}}}
\subsection{Method \code{get_param_constraints()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$get_param_constraints()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get additional (non-linear) equality constraints on Distribution
parameters
}

\subsection{Returns}{
\code{NULL} if the box constraints specified by
\code{dist$get_param_bounds()} are sufficient, or a function taking full
Distribution parameters and returning either a numeric vector
(which must be 0 for valid parameter combinations) or a list with
elements
\itemize{
\item \code{constraints}: The numeric vector of constraints
\item \code{jacobian}: The Jacobi matrix of the constraints with respect to the
parameters
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dist_mixture(
  list(dist_dirac(), dist_exponential())
)$get_param_constraints()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-export_functions"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-export_functions}{}}}
\subsection{Method \code{export_functions()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$export_functions(
  name,
  envir = parent.frame(),
  with_params = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{common suffix of the exported functions}

\item{\code{envir}}{Environment to export the functions to}

\item{\code{with_params}}{Optional list of parameters to use as default values
for the exported functions}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Export sampling, density, probability and quantile functions
to plain R functions

Creates new functions in \code{envir} named \verb{\{r,d,p,q\}<name>} which implement
\code{dist$sample}, \code{dist$density}, \code{dist$probability} and \code{dist$quantile} as
plain functions with default arguments specified by \code{with_params} or the
fixed parameters.

The resulting functions will have signatures taking all parameters as
separate arguments.
}

\subsection{Returns}{
Invisibly \code{NULL}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tmp_env <- new.env(parent = globalenv())
dist_exponential()$export_functions(
  name = "exp",
  envir = tmp_env,
  with_params = list(rate = 2.0)
)
evalq(
  fitdistrplus::fitdist(rexp(100), "exp"),
  envir = tmp_env
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Distribution-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Distribution-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Distribution$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
