% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_poisson.R
\name{dist_poisson}
\alias{dist_poisson}
\title{Poisson Distribution}
\usage{
dist_poisson(lambda = NULL)
}
\arguments{
\item{lambda}{Scalar rate parameter, or \code{NULL} as a placeholder.}
}
\value{
A \code{PoissonDistribution} object.
}
\description{
See \link[stats:Poisson]{stats::Poisson}
}
\details{
The parameter can be overridden with
\code{with_params = list(lambda = ...)}.
}
\examples{
d_pois <- dist_poisson(lambda = 5.0)
x <- d_pois$sample(100)
d_emp <- dist_empirical(x)

plot_distributions(
  empirical = d_emp,
  theoretical = d_pois,
  estimated = d_pois,
  with_params = list(
    estimated = inflate_params(
      fitdistrplus::fitdist(x, distr = "pois")$estimate
    )
  ),
  .x = 0:max(x)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
