% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackForest.R
\name{PackForest}
\alias{PackForest}
\title{Packs a forest and saves modified forest to disk for use by PackPredict function}
\usage{
PackForest(X, Y, forest)
}
\arguments{
\item{X}{an n by d numeric matrix (preferable) or data frame used to train the forest.}

\item{Y}{a numeric vector of size n.  If the Y vector used to train the forest was not of type numeric then a simple call to as.numeric(Y) will suffice as input.}

\item{forest}{a forest trained using the RerF function using the RF option.}
}
\description{
Efficiently packs a forest trained with the RF option.  Two intermediate data structures are written to disk, forestPackTempFile.csv and traversalPackTempFile.csv.  The size of these data structures is proportional to a trained forest and training data respectively.  Both data structures are removed at the end of the operation.  The resulting forest is saved as forest.out.  The size of this file is similar to the size of the trained forest.
}
