% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_untag}
\alias{repo_untag}
\title{Remove tags from an item.}
\usage{
repo_untag(repo, name = NULL, rmtags, tags = NULL)
}
\arguments{
\item{repo}{An object of class repo.}

\item{name}{An item name.}

\item{rmtags}{A list of tags that will be removed from the item's
tag list.}

\item{tags}{A list of tags: rmtags will be removed from all items
matching the list.}
}
\value{
Used for side effects.
}
\description{
Remove tags from an item.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)
repo$put(1, "item1", "Sample item 1", c("tag1", "tag2"), replace=TRUE)
repo$print(show="t")
repo$untag("item1", "tag2")
repo$print(show="t")

## wiping temporary repo
unlink(repo_path, TRUE)
}

