% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinController.R
\name{executeLeftJoinPlan}
\alias{executeLeftJoinPlan}
\title{Execute an ordered sequence of left joins.}
\usage{
executeLeftJoinPlan(tDesc, columnJoinPlan, ..., checkColumns = FALSE,
  computeFn = function(x, name) {     dplyr::compute(x, name = name) },
  eagerCompute = TRUE, checkColClasses = FALSE, verbose = FALSE,
  dryRun = FALSE,
  tempNameGenerator = mk_tmp_name_source("executeLeftJoinPlan"))
}
\arguments{
\item{tDesc}{description of tables, either a \code{data.frame} from \code{\link{tableDescription}}, or a list mapping from names to handles/frames.  Only used to map table names to data.}

\item{columnJoinPlan}{columns to join, from \code{\link{buildJoinPlan}} (and likely altered by user).  Note: no column names must intersect with names of the form \code{table_CLEANEDTABNAME_present}.}

\item{...}{force later arguments to bind by name.}

\item{checkColumns}{logical if TRUE confirm column names before starting joins.}

\item{computeFn}{function to call to try and materialize intermediate results.}

\item{eagerCompute}{logical if TRUE materialize intermediate results with computeFn.}

\item{checkColClasses}{logical if true check for exact class name matches}

\item{verbose}{logical if TRUE print more.}

\item{dryRun}{logical if TRUE do not perform joins, only print steps.}

\item{tempNameGenerator}{temp name generator produced by wrapr::mk_tmp_name_source, used to record dplyr::compute() effects.}
}
\value{
joined table
}
\description{
Please see \code{vignette('DependencySorting', package = 'replyr')} and \code{vignette('joinController', package= 'replyr')} for more details.
}
\examples{


# example data
meas1 <- data.frame(id= c(1,2),
                    weight= c(200, 120),
                    height= c(60, 14))
meas2 <- data.frame(pid= c(2,3),
                    weight= c(105, 110),
                    width= 1)
# get the initial description of table defs
tDesc <- rbind(tableDescription('meas1', meas1),
               tableDescription('meas2', meas2))
# declare keys (and give them consitent names)
tDesc$keys[[1]] <- list(PatientID= 'id')
tDesc$keys[[2]] <- list(PatientID= 'pid')
# build the column join plan
columnJoinPlan <- buildJoinPlan(tDesc)
# decide we don't want the width column
columnJoinPlan$want[columnJoinPlan$resultColumn=='width'] <- FALSE
# double check our plan
if(!is.null(inspectDescrAndJoinPlan(tDesc, columnJoinPlan,
            checkColClasses= TRUE))) {
  stop("bad join plan")
}
# execute the left joins
executeLeftJoinPlan(tDesc, columnJoinPlan,
                    checkColClasses= TRUE,
                    verbose= TRUE)
# also good
executeLeftJoinPlan(list('meas1'=meas1, 'meas2'=meas2),
                    columnJoinPlan,
                    checkColClasses= TRUE,
                    verbose= TRUE)

}
\seealso{
\code{\link{tableDescription}}, \code{\link{buildJoinPlan}}, \code{\link{inspectDescrAndJoinPlan}}, \code{\link{makeJoinDiagramSpec}}

TODO: parameterize the implementation provider (right now hard-coded for \code{dplr}, but at least also direct \code{SQL} is a good extension).
}
