% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowscols.R
\name{buildPivotControlTable}
\alias{buildPivotControlTable}
\title{Build a moveValuesToColumnsQ() control table that specifies a pivot.}
\usage{
buildPivotControlTable(d, columnToTakeKeysFrom, columnToTakeValuesFrom, ...,
  prefix = columnToTakeKeysFrom, sep = NULL)
}
\arguments{
\item{d}{data to scan for new column names}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{...}{not used, force later args to be by name}

\item{prefix}{column name prefix (only used when sep is not NULL)}

\item{sep}{separator to build complex column names.}
}
\value{
control table
}
\description{
Some discussion and examples can be found here: \url{https://winvector.github.io/replyr/articles/FluidData.html}.
}
\examples{

d <- data.frame(measType = c("wt", "ht"),
                measValue = c(150, 6),
                stringsAsFactors = FALSE)
buildPivotControlTable(d, 'measType', 'measValue', sep='_')

}
\seealso{
\url{https://github.com/WinVector/cdata}, \code{\link[cdata]{moveValuesToRows}}, \code{\link[cdata]{moveValuesToColumns}}, \code{\link{moveValuesToRowsQ}}, \code{\link{moveValuesToColumnsQ}}
}
