% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce.R
\name{replyr_coalesce}
\alias{replyr_coalesce}
\title{Augment a data frame by adding additional rows.}
\usage{
replyr_coalesce(data, support, ..., fills = NULL, newRowColumn = NULL,
  copy = TRUE)
}
\arguments{
\item{data}{data.frame data to augment}

\item{support}{data.frame rows of unique key-values into data}

\item{...}{not used, force later arguments to bind by name}

\item{fills}{list default values to fill in columns}

\item{newRowColumn}{character if not null name to use for new row indicator}

\item{copy}{logical sets copy during dplyr::anti_join}
}
\value{
augmented data
}
\description{
Note: do not count on order of resulting data.  Also only added rows
are altered by the fill instructions.
}
\examples{


# single column key example
data <- data.frame(year = c(2005,2007,2010),
                   count = c(6,1,NA),
                   name = c('a','b','c'),
                   stringsAsFactors = FALSE)
support <- data.frame(year=2005:2010)
filled <- replyr_coalesce(data, support,
                          fills=list(count=0))
filled <- filled[order(filled$year), ]
filled

# complex key example
data <- data.frame(year = c(2005,2007,2010),
                   count = c(6,1,NA),
                   name = c('a','b','c'),
                   stringsAsFactors = FALSE)
support <- expand.grid(year=2005:2010,
                   name= c('a','b','c','d'),
                   stringsAsFactors = FALSE)
filled <- replyr_coalesce(data, support,
                          fills=list(count=0))
filled <- filled[order(filled$year, filled$name), ]
filled

}
