% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/replicationInterval.R
\name{ri.r}
\alias{ri.r}
\title{Creates a replication interval based on a published/sample correlation.}
\usage{
ri.r(r, n, rep.n = NA, conf.level = 0.95, explain = FALSE,
  extended.output = FALSE, manuscript.text = TRUE)
}
\arguments{
\item{r}{Original study: Correlation}

\item{n}{Original study: Sample size}

\item{rep.n}{(optional) Replication study: Sample size. If not specified, n is used.}

\item{conf.level}{(optional 0 to 1 value) Confidence level desired (0 to 1). If not specified .95 (i.e., 95 percent) will be used.}

\item{explain}{(optional boolean) Default is FALSE. If TRUE, text output explaining the interval is provided.}

\item{extended.output}{(optional boolean) Default is FALSE. If TRUE, additional details (e.g., confidence interval) provided in numeric return output.}

\item{manuscript.text}{(optional boolean) Default is TRUE. If TRUE, present text for Method section.}
}
\value{
A list of values (\code{lower.replication.interval.r, upper.replication.interval.r}) containing the replication interval (and related statistics if requested with the \code{extended.output} argument).
}
\description{
Creates a replication interval based on a published/sample correlation.
}
\examples{
ri.r(r=.35,n=40)
ri.r(r=.35,n=40,explain=TRUE)
}

