% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture.r
\name{capture}
\alias{capture}
\alias{setup}
\title{Capture-recapture Models}
\usage{
capture(z, n)
}
\arguments{
\item{z}{A Poisson generalized linear model object.}

\item{n}{The number of repeated observations.}
}
\value{
\code{capture} returns a matrix containing the estimates.
}
\description{
\code{capture} fits the Cormack capture-recapture model to \code{n} sample
periods. Set \code{n} to the appropriate value and type \code{eval(setup)}.
}
\details{
\code{n <- periods} # number of periods

\code{eval(setup)}

This produces the following variables -

\code{p[i]}: logit capture probabilities,

\code{pbd}: constant capture probability,

\code{d[i]}: death parameters,

\code{b[i]}: birth parameters,

\code{pw}: prior weights.

Then set up a Poisson model for log linear models:

\code{z <- glm(y~model, family=poisson, weights=pw)}

and call the function, \code{capture}.

If there is constant effort, then all estimates are correct. Otherwise,
\code{n[1]}, \code{p[1]}, \code{b[1]}, are correct only if there is no
birth in period 1.  \code{n[s]}, \code{p[s]}, are correct only if there is
no death in the last period.  \code{phi[s-1]} is correct only if effort is
constant in \code{(s-1, s)}.  \code{b[s-1]} is correct only if \code{n[s]}
and \code{phi[s-1]} both are.
}
\examples{

y <- c(0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,14,1,1,0,2,1,2,1,16,0,2,0,11,
	2,13,10,0)
n <- 5
eval(setup)
# closed population
print(z0 <- glm(y~p1+p2+p3+p4+p5, family=poisson, weights=pw))
# deaths and emigration only
print(z1 <- update(z0, .~.+d1+d2+d3))
# immigration only
print(z2 <- update(z1, .~.-d1-d2-d3+b2+b3+b4))
# deaths, emigration, and immigration
print(z3 <- update(z2, .~.+d1+d2+d3))
# add trap dependence
print(z4 <- update(z3, .~.+i2+i3))
# constant capture probability over the three middle periods
print(z5 <- glm(y~p1+pbd+p5+d1+d2+d3+b2+b3+b4, family=poisson, weights=pw))
# print out estimates
capture(z5, n)

}
\author{
J.K. Lindsey
}
\keyword{models}

