% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_lm_contrasts.R
\name{nice_lm_contrasts}
\alias{nice_lm_contrasts}
\title{Easy planned contrasts using lm models}
\usage{
nice_lm_contrasts(
  model,
  group,
  data,
  p_adjust = "none",
  effect.type = "cohens.d",
  bootstraps = 2000,
  ...
)
}
\arguments{
\item{model}{The model to be formatted.}

\item{group}{The group for the comparison.}

\item{data}{The data frame.}

\item{p_adjust}{Character: adjustment method (e.g., "bonferroni") – added to options}

\item{effect.type}{What effect size type to use. One of "cohens.d" (default),
"akp.robust.d", "unstandardized", "hedges.g", "cohens.d.sigma", or "r".}

\item{bootstraps}{The number of bootstraps to use for the confidence interval}

\item{...}{Arguments passed to \link[bootES:bootES]{bootES::bootES}.}
}
\value{
A dataframe, with the selected dependent variable(s), comparisons of
interest, degrees of freedom, t-values, p-values, Cohen's d, and the
lower and upper 95\% confidence intervals of the
effect size (i.e., dR).
}
\description{
Easily compute planned contrast analyses (pairwise
comparisons similar to t-tests but more powerful when more than
2 groups), and format in publication-ready format. In this particular
case, the confidence intervals are bootstraped on chosen effect size
(default to Cohen's d).
}
\details{
Statistical power is lower with the standard \emph{t} test
compared than it is with the planned contrast version for two
reasons: a) the sample size is smaller with the \emph{t} test,
because only the cases in the two groups are selected; and b)
in the planned contrast the error term is smaller than it is
with the standard \emph{t} test because it is based on all the cases
(\href{https://web.pdx.edu/~newsomj/uvclass/ho_planned\%20contrasts.pdf}{source}).

The effect size and confidence interval are calculated via
\link[bootES:bootES]{bootES::bootES}, and correct for contrasts but not for covariates and
other predictors. Because this method uses bootstrapping, it is recommended
to set a seed before using for reproducibility reasons (e.g.,
\code{sed.seet(100)}).

Does not for the moment support nested comparisons for marginal means,
only a comparison of all groups. For nested comparisons, please use
\code{\link[emmeans:contrast]{emmeans::contrast()}} directly, or for the \emph{easystats} equivalent,
\code{\link[modelbased:estimate_contrasts]{modelbased::estimate_contrasts()}}.

When using \code{nice_lm_contrasts()}, please use \code{as.factor()} outside the
\code{lm()} formula, or it will lead to an error.
}
\examples{
\dontshow{if (requireNamespace("bootES", quietly = TRUE) && requireNamespace("modelbased", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Make and format model (group need to be a factor)
mtcars2 <- mtcars
mtcars2$cyl <- as.factor(mtcars2$cyl)
model <- lm(mpg ~ cyl + wt * hp, mtcars2)
set.seed(100)
nice_lm_contrasts(model, group = "cyl", data = mtcars, bootstraps = 500)

# Several models at once
mtcars2$gear <- as.factor(mtcars2$gear)
model2 <- lm(qsec ~ cyl, data = mtcars2)
my.models <- list(model, model2)
set.seed(100)
nice_lm_contrasts(my.models, group = "cyl", data = mtcars, bootstraps = 500)

# Now supports more than 3 levels
mtcars2$carb <- as.factor(mtcars2$carb)
model <- lm(mpg ~ carb + wt * hp, mtcars2)
set.seed(100)
nice_lm_contrasts(model, group = "carb", data = mtcars2, bootstraps = 500)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{nice_contrasts}},
Tutorial: \url{https://rempsyc.remi-theriault.com/articles/contrasts}
}
\keyword{comparisons}
\keyword{contrasts}
\keyword{differences}
\keyword{group}
\keyword{pairwise}
\keyword{planned}
