% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algoInvHist.R
\name{estimateStartValues}
\alias{estimateStartValues}
\title{Helper function to estimate search regions for mu and sigma and to get the region around main peak 'ab'}
\usage{
estimateStartValues(Data, lambdaVec, useQuantiles = FALSE)
}
\arguments{
\item{Data}{(numeric) values specifying data points comprising pathological
and non-pathological values}

\item{lambdaVec}{(numeric) transformation parameter for inverse Box-Cox transformation}

\item{useQuantiles}{(logical) indicating if quantiles or raw data should be used (for more than 100000 data points 
quantiles are always used)}
}
\value{
(list) with (abOriginal, search region for mu and sigma)
}
\description{
The function estimates start search regions for mu and sigma for each lambda. Further it determines an appropriate 
region around the main peak 'ab' that is used for all lambdas.
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
