% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_ncbi_taxonomy.R
\name{refdb_set_ncbitax}
\alias{refdb_set_ncbitax}
\title{Replace the current taxonomy using the NCBI Taxonomy database}
\usage{
refdb_set_ncbitax(
  x,
  min_level = "species",
  force_species_name = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{a reference database (tibble) with one or several columns
giving the taxonomy of each record and explicitly
indicated in the field taxonomy. See \link{refdb_set_fields}.}

\item{min_level}{minimum taxonomic level at which taxonomy
should be replaced. Default is the finest level (\code{"species"}).}

\item{force_species_name}{if \code{TRUE}, species not found in NCBI Taxonomy
will keep their original names instead of NAs.}

\item{verbose}{print information in the console.}
}
\value{
The reference database with the NCBI taxonomy
for the genus level and higher ranks.
(the original taxonomy above the genus level is removed).
}
\description{
Replace the current taxonomy using the NCBI Taxonomy database
}
\examples{
\dontrun{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_set_ncbitax(lib)
}
}
