% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_plots.R
\name{refdb_plot_tax_barplot}
\alias{refdb_plot_tax_barplot}
\title{Barplots of the number of records for the most represented taxa}
\usage{
refdb_plot_tax_barplot(x, show_n = 10)
}
\arguments{
\item{x}{a reference database.}

\item{show_n}{an integer value indicating the number of taxa to show in each panel.}
}
\value{
A ggplot object.
}
\description{
Generate a multipanel plot where, for each taxonomic level,
a barplot represent the number of records available
in the reference database for the most represented taxa.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
lib <- refdb_set_fields(lib, latitude = "lat", longitude = "lon")
refdb_plot_tax_barplot(lib)

}
